/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityButtonsEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityEntity;
import com.bizunited.platform.kuiper.starter.common.enums.TemplateLayoutTypeEnum;
import com.bizunited.platform.kuiper.starter.repository.TemplateVisibilityButtonRepository;
import com.bizunited.platform.kuiper.starter.service.KuiperToolkitService;
import com.bizunited.platform.kuiper.starter.service.TemplateVisibilityButtonService;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="TemplateVisibilityButtonServiceImpl")
public class TemplateVisibilityButtonServiceImpl
implements TemplateVisibilityButtonService {
    @Autowired
    @Qualifier(value="KuiperToolkitService")
    private KuiperToolkitService kuiperToolkitService;
    @Autowired
    private TemplateVisibilityButtonRepository templateVisibilityButtonRepository;
    @Autowired
    private PlatformContext platformContext;

    private void saveValidation(TemplateVisibilityEntity visibility, Set<TemplateVisibilityButtonsEntity> buttons) {
        Validate.notNull((Object)visibility, (String)"\u53ef\u89c1\u6027\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(buttons)) {
            return;
        }
        HashSet<String> controlIdSet = new HashSet<String>();
        for (TemplateVisibilityButtonsEntity button : buttons) {
            Validate.notBlank((CharSequence)button.getControllerId(), (String)"\u63a7\u4ef6\u7684\u552f\u4e00\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Validate.notNull((Object)button.getVisible(), (String)"\u63a7\u4ef6\u7684\u53ef\u89c1\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Integer layoutType = button.getLayoutType() == null ? TemplateLayoutTypeEnum.PC.getType() : button.getLayoutType();
            boolean flag = controlIdSet.add(StringUtils.join((Object[])new Serializable[]{layoutType, "|", button.getControllerId()}));
            Validate.isTrue((boolean)flag, (String)"\u6309\u94aecontrollerId\u7f16\u53f7\u91cd\u590d,\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        }
    }

    @Override
    @Transactional
    public Set<TemplateVisibilityButtonsEntity> save(TemplateVisibilityEntity visibility, Set<TemplateVisibilityButtonsEntity> buttons) {
        if (buttons == null) {
            buttons = new HashSet<TemplateVisibilityButtonsEntity>();
        }
        this.saveValidation(visibility, buttons);
        HashSet<TemplateVisibilityButtonsEntity> savedButtons = new HashSet<TemplateVisibilityButtonsEntity>();
        Set<TemplateVisibilityButtonsEntity> oldButtons = this.templateVisibilityButtonRepository.findByVisiblId(visibility.getId());
        if (oldButtons == null) {
            oldButtons = new HashSet<TemplateVisibilityButtonsEntity>();
        }
        HashMap<String, TemplateVisibilityButtonsEntity> buttonsMap = new HashMap<String, TemplateVisibilityButtonsEntity>(16);
        for (TemplateVisibilityButtonsEntity button2 : buttons) {
            Integer layoutType = button2.getLayoutType() == null ? TemplateLayoutTypeEnum.PC.getType() : button2.getLayoutType();
            String key = StringUtils.join((Object[])new Serializable[]{layoutType, "|", button2.getControllerId()});
            button2.setLayoutType(layoutType);
            buttonsMap.put(key, button2);
        }
        HashSet addButtons = new HashSet();
        HashSet updateButtons = new HashSet();
        HashSet deleteButtons = new HashSet();
        this.kuiperToolkitService.collectionDiscrepancy(buttons, oldButtons, button -> {
            Integer layoutType = button.getLayoutType() == null ? TemplateLayoutTypeEnum.PC.getType() : button.getLayoutType();
            return StringUtils.join((Object[])new Serializable[]{layoutType, "|", button.getControllerId()});
        }, deleteButtons, updateButtons, addButtons);
        for (TemplateVisibilityButtonsEntity button3 : addButtons) {
            button3.setId(null);
            button3.setTemplateVisibility(visibility);
            button3.setProjectName(this.platformContext.getAppName());
            this.templateVisibilityButtonRepository.save(button3);
            savedButtons.add(button3);
        }
        for (TemplateVisibilityButtonsEntity button3 : updateButtons) {
            Integer layoutType = button3.getLayoutType() == null ? TemplateLayoutTypeEnum.PC.getType() : button3.getLayoutType();
            String key = StringUtils.join((Object[])new Serializable[]{layoutType, "|", button3.getControllerId()});
            TemplateVisibilityButtonsEntity newButton = (TemplateVisibilityButtonsEntity)buttonsMap.get(key);
            button3.setLayoutType(layoutType);
            button3.setTemplateVisibility(visibility);
            button3.setVisible(newButton.getVisible());
            this.templateVisibilityButtonRepository.save(button3);
            savedButtons.add(button3);
        }
        return savedButtons;
    }

    @Override
    @Transactional
    public void deleteByVisibilityId(String visibilityId) {
        Set<TemplateVisibilityButtonsEntity> buttons = this.templateVisibilityButtonRepository.findByVisiblId(visibilityId);
        if (!CollectionUtils.isEmpty(buttons)) {
            this.templateVisibilityButtonRepository.deleteAll(buttons);
        }
    }

    @Override
    public Set<TemplateVisibilityButtonsEntity> findByVisibilityIdAndLayoutType(String visibilityId, Integer layoutType) {
        if (StringUtils.isBlank((CharSequence)visibilityId)) {
            return Sets.newHashSet();
        }
        if (layoutType == null) {
            layoutType = TemplateLayoutTypeEnum.PC.getType();
        }
        return this.templateVisibilityButtonRepository.findByVisibilityIdAndLayoutType(visibilityId, layoutType);
    }
}

