/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.migrate.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.enums.ImportExecuteModeEnum;
import com.bizunited.platform.common.enums.MigrateDataTypeEnum;
import com.bizunited.platform.common.enums.NormalStatusEnum;
import com.bizunited.platform.common.model.MigrateImportModel;
import com.bizunited.platform.common.util.FileUtils;
import com.bizunited.platform.kuiper.entity.MigrateImportDetailEntity;
import com.bizunited.platform.kuiper.entity.MigrateImportEntity;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.repository.migrate.MigrateImportDetailRepository;
import com.bizunited.platform.kuiper.starter.repository.migrate.MigrateImportRepository;
import com.bizunited.platform.kuiper.starter.service.FrontFileSevice;
import com.bizunited.platform.kuiper.starter.service.ListTemplateService;
import com.bizunited.platform.kuiper.starter.service.PageFlowService;
import com.bizunited.platform.kuiper.starter.service.migrate.MigrateImportService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import com.bizunited.platform.venus.common.service.image.FileUpdateService;
import com.bizunited.platform.venus.common.vo.OrdinaryFileVo;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.zip.ZipFile;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Service(value="kuiperMigrateImportService")
public class MigrateImportServiceImpl
implements MigrateImportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrateImportServiceImpl.class);
    @Value(value="${venus.file.fileRoot}")
    private String fileRoot;
    @Autowired
    private MigrateImportRepository migrateImportRepository;
    @Autowired
    private MigrateImportDetailRepository migrateImportDetailRepository;
    @Autowired
    private UserService userService;
    @Autowired
    private PageFlowService pageFlowService;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private VenusFileService venusFileService;
    @Autowired
    private FileUpdateService fileUpdateService;
    @Autowired
    private ListTemplateService listTemplateService;
    @Autowired
    private FrontFileSevice frontFileSevice;
    @Autowired
    private PlatformContext platformContext;

    @Override
    @Transactional
    public MigrateImportEntity upload(MultipartFile file, Integer dataType) {
        Validate.notNull((Object)file, (String)"\u4e0a\u4f20\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)dataType, (String)"\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        MigrateDataTypeEnum dataTypeEnum = MigrateDataTypeEnum.valueOfType((int)dataType);
        Validate.notNull((Object)dataTypeEnum, (String)"\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b\uff1a%d", (Object[])new Object[]{dataType});
        UserVo userVo = SecurityUtils.getCurrentUser();
        MigrateImportEntity migrateImport = new MigrateImportEntity();
        migrateImport.setCreateTime(new Date());
        migrateImport.setExecuted(Boolean.valueOf(false));
        migrateImport.setDataType(dataType);
        migrateImport.setCreator(userVo.getAccount());
        migrateImport.setOriginalFileName(file.getOriginalFilename());
        Object[] files = new MultipartFile[]{file};
        List ordinaryFileEntities = this.fileUpdateService.fileUpload("migrate", userVo.getAccount(), null, (MultipartFile[])files);
        Validate.notEmpty((Object[])files, (String)"\u4fdd\u5b58\u4e0a\u4f20\u6587\u4ef6\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        OrdinaryFileVo fileEntity = (OrdinaryFileVo)ordinaryFileEntities.get(0);
        Validate.notNull((Object)fileEntity, (String)"\u4e0a\u6b21\u6587\u4ef6\u4fdd\u5b58\u8fd4\u56de\u7ed3\u679c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        migrateImport.setFileName(fileEntity.getFileName());
        migrateImport.setRelativeLocal(fileEntity.getRelativeLocal());
        migrateImport.setProjectName(this.platformContext.getAppName());
        return this.create(migrateImport);
    }

    @Override
    @Transactional
    public MigrateImportEntity create(MigrateImportEntity migrateImport) {
        Validate.notNull((Object)migrateImport.getCreateTime(), (String)"\u4fdd\u5b58\u8bb0\u5f55\u65f6\uff0c\u5bfc\u5165\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)migrateImport.getRelativeLocal(), (String)"\u8fc1\u5165\u6587\u4ef6\u5728\u672c\u5730\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)migrateImport.getFileName(), (String)"\u8fc1\u5165\u6587\u4ef6\u91cd\u547d\u540d\u540e\u7684\u6587\u4ef6\u540d\u5b57\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)migrateImport.getCreator(), (String)"\u8fc1\u5165\u6587\u4ef6\u4e0a\u4f20\u4eba\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)migrateImport.getCreateTime(), (String)"\u8fc1\u5165\u6587\u4ef6\u4e0a\u4f20\u65f6\u95f4\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)migrateImport.getExecuted(), (String)"\u8fc1\u5165\u6587\u4ef6\u4efb\u52a1\u662f\u5426\u88ab\u6267\u884c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        migrateImport.setProjectName(this.platformContext.getAppName());
        return (MigrateImportEntity)this.migrateImportRepository.saveAndFlush(migrateImport);
    }

    @Override
    public List<MigrateImportEntity> findDetailsByDataType(Integer dataType) {
        if (dataType == null) {
            return Lists.newArrayList();
        }
        List<MigrateImportEntity> imports = null;
        String projectName = this.platformContext.getAppName();
        imports = StringUtils.isNotBlank((CharSequence)projectName) ? this.migrateImportRepository.findByDataTypeAndProjectName(dataType, projectName) : this.migrateImportRepository.findByDataTypeAndBlankProjectName(dataType);
        if (CollectionUtils.isEmpty(imports)) {
            return Lists.newArrayList();
        }
        return this.loadUsers(imports);
    }

    private List<MigrateImportEntity> loadUsers(List<MigrateImportEntity> imports) {
        HashMap<String, UserVo> tmp = new HashMap<String, UserVo>();
        for (MigrateImportEntity anImport : imports) {
            String creator = anImport.getCreator();
            UserVo createUser = (UserVo)tmp.get(creator);
            if (createUser == null) {
                createUser = this.userService.findByAccount(creator);
                tmp.put(creator, createUser);
            }
            anImport.setCreateUser(createUser);
            String executor = anImport.getExecutor();
            if (!StringUtils.isNotBlank((CharSequence)executor)) continue;
            UserVo executeUser = (UserVo)tmp.get(executor);
            if (executeUser == null) {
                executeUser = this.userService.findByAccount(executor);
                tmp.put(executor, executeUser);
            }
            anImport.setExecuteUser(executeUser);
        }
        return imports;
    }

    @Override
    public MigrateImportEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        MigrateImportEntity migrateImportEntity = this.migrateImportRepository.findById(id).orElse(null);
        if (migrateImportEntity == null) {
            return null;
        }
        if (migrateImportEntity.getDetail() == null) {
            return null;
        }
        return migrateImportEntity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional
    public MigrateImportEntity execute(String id, Integer mode) {
        ImportExecuteModeEnum executeMode;
        Validate.notBlank((CharSequence)id, (String)"\u5bfc\u5165\u8bb0\u5f55ID\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        if (mode == null) {
            executeMode = ImportExecuteModeEnum.SKIP;
        } else {
            executeMode = ImportExecuteModeEnum.valueOfMode((int)mode);
            Validate.notNull((Object)executeMode, (String)"\u4e0d\u652f\u6301\u7684\u6267\u884c\u6a21\u5f0f\uff1a%s", (Object[])new Object[]{mode});
        }
        UserVo userVo = SecurityUtils.getCurrentUser();
        MigrateImportEntity migrateImport = this.migrateImportRepository.findById(id).orElse(null);
        Validate.notNull((Object)migrateImport, (String)"\u672a\u627e\u5230\u5bfc\u5165\u7684\u8bb0\u5f55", (Object[])new Object[0]);
        MigrateDataTypeEnum dataType = MigrateDataTypeEnum.valueOfType((int)migrateImport.getDataType());
        Validate.notNull((Object)dataType, (String)"\u4e0d\u652f\u6301\u5bfc\u5165\u7684\u6570\u636e\u7c7b\u578b:%s", (Object[])new Object[]{migrateImport.getDataType()});
        byte[] bytes = this.venusFileService.readFileContent(migrateImport.getRelativeLocal(), migrateImport.getFileName());
        MigrateImportDetailEntity importDetail = migrateImport.getDetail();
        if (importDetail == null) {
            importDetail = new MigrateImportDetailEntity();
        }
        Validate.isTrue((bytes != null && bytes.length > 0 ? 1 : 0) != 0, (String)"\u5bfc\u5165\u7684\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a", (Object[])new Object[0]);
        File tmpFile = FileUtils.writeLocalFile((byte[])bytes, (String)this.fileRoot, (String)"zip");
        int executeResult = NormalStatusEnum.ENABLE.getStatus();
        try (ZipFile zipFile = new ZipFile(tmpFile);){
            MigrateImportModel importModel = new MigrateImportModel(zipFile, executeMode);
            try {
                switch (dataType) {
                    case LIST_TEMPLATE: {
                        this.listTemplateService.importData(importModel);
                        break;
                    }
                    case PAGE_FLOW: {
                        this.pageFlowService.importData(importModel);
                        break;
                    }
                    case FORM_TEMPLATE: {
                        this.templateService.importData(importModel);
                        break;
                    }
                    case FRONT_FILE: {
                        this.frontFileSevice.importData(importModel);
                        break;
                    }
                    default: {
                        importModel.setError(true);
                        importModel.appendLine("\u5bfc\u5165\u9519\u8bef\uff1a\u4e0d\u652f\u6301\u7684\u6570\u636e\u7c7b\u578b\u3010%s\u3011", new Object[]{dataType.name()});
                    }
                }
                importModel.appendLine("\u5bfc\u5165\u5b8c\u6210\uff01");
            }
            catch (RuntimeException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                importModel.setError(true);
                importModel.append("\u5bfc\u5165\u9519\u8bef\uff1a").appendLine(e.getMessage());
            }
            finally {
                importDetail.setCreateCount(Integer.valueOf(importModel.getCreateCount()));
                importDetail.setIgnoreCount(Integer.valueOf(importModel.getSkipCount()));
                importDetail.setTotalCount(Integer.valueOf(importModel.getTotalCount()));
                importDetail.setUpdateCount(Integer.valueOf(importModel.getUpdateCount()));
                importDetail.setExecuteLog(importModel.getExecuteLog().toString());
                if (importModel.isError()) {
                    executeResult = NormalStatusEnum.DISABLE.getStatus();
                }
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(String.format("\u8bfb\u53d6\u538b\u7f29\u6587\u4ef6\u51fa\u9519\uff1a%s", e.getMessage()));
        }
        finally {
            tmpFile.delete();
        }
        importDetail.setProjectName(this.platformContext.getAppName());
        this.migrateImportDetailRepository.saveAndFlush(importDetail);
        migrateImport.setDetail(importDetail);
        migrateImport.setExecuted(Boolean.valueOf(true));
        migrateImport.setExecutor(userVo.getAccount());
        migrateImport.setExecuteTime(new Date());
        migrateImport.setExecuteResult(Integer.valueOf(executeResult));
        migrateImport.setProjectName(this.platformContext.getAppName());
        this.migrateImportRepository.saveAndFlush(migrateImport);
        return migrateImport;
    }
}

