/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseCode;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.InstanceActivityLogEntity;
import com.bizunited.platform.kuiper.starter.service.InstanceActivityLogService;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/kuiper/activityLogs"})
public class InstanceActivityLogController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceActivityLogController.class);
    @Autowired
    private InstanceActivityLogService instanceActivityLogService;

    @GetMapping(value={"/findDetailsByInstanceActivity"})
    @ApiOperation(value="\u6309\u7167\u6d3b\u52a8\u7f16\u53f7\uff0c\u67e5\u8be2\u6307\u5b9a\u7684\u6d3b\u52a8\u4fe1\u606f\u8be6\u60c5\u2014\u2014\u5305\u62ec\u5173\u8054\u4fe1\u606f\uff0c\u5e76\u6309\u7167\u65f6\u95f4\u987a\u5e8f\u8fdb\u884c\u8fd4\u56de")
    public ResponseModel findDetailsByInstanceActivity(@RequestParam(value="instanceActivityId") String instanceActivityId) {
        try {
            Set<InstanceActivityLogEntity> logs = this.instanceActivityLogService.findDetailsByInstanceActivity(instanceActivityId);
            return this.buildHttpResultW(logs, new String[]{"instanceActivity", "creator"});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"/findDetailsById"})
    @ApiOperation(value="\u6309\u7167\u6d3b\u52a8\u7f16\u53f7\uff0c\u67e5\u8be2\u6307\u5b9a\u7684\u6d3b\u52a8\u4fe1\u606f\u8be6\u60c5\u2014\u2014\u5305\u62ec\u5173\u8054\u4fe1\u606f")
    public ResponseModel findDetailsById(@RequestParam(value="instanceActivityLogId") String instanceActivityLogId) {
        try {
            InstanceActivityLogEntity log = this.instanceActivityLogService.findDetailsById(instanceActivityLogId);
            return this.buildHttpResultW(log, new String[]{"instanceActivity", "creator"});
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"/findContentById"})
    @ApiOperation(value="\u67e5\u8be2\u6307\u5b9a\u6d3b\u52a8\u53d8\u5316\u65e5\u5fd7\u7684\u8be6\u7ec6\u5185\u5bb9", notes="\u6ce8\u610f\uff0c\u8fd9\u91cc\u67e5\u8be2\u7684\u662f\u53d8\u5316\u8be6\u7ec6\u5185\u5bb9\u7684json\u4fe1\u606f\u3002")
    public ResponseModel findContentById(@RequestParam(value="instanceActivityLogId") String instanceActivityLogId) {
        try {
            JSONObject jsonObject = this.instanceActivityLogService.findContentById(instanceActivityLogId);
            return this.buildHttpResultW(jsonObject, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"/findTop/{instanceId}"})
    @ApiOperation(value="\u6309\u7167\u6307\u5b9a\u7684\u5b9e\u4f8b\u7f16\u53f7\uff0c\u67e5\u8be2\u8fd9\u4e2a\u5b9e\u4f8b\u7f16\u53f7\u4e0b\u6700\u540e\u4e00\u6b21\u53d1\u751f\u7684\u6570\u636e\u53d8\u5316\u65e5\u5fd7", notes="\u8fd4\u56de\u7684\u6570\u636e\u4e2d\u6709\u4e00\u4e2a\u5b57\u7b26\u4e32\uff0c\u8bf4\u660e\u5f53\u524d\u6700\u540e\u4e00\u6b21\u64cd\u4f5c\u65e5\u5fd7\u7684\u7f16\u53f7")
    public ResponseModel findTopByInstanceId(@PathVariable(value="instanceId") String instanceId) {
        try {
            String logid = this.instanceActivityLogService.findTopByInstanceId(instanceId);
            ResponseModel result = new ResponseModel(Long.valueOf(new Date().getTime()), null, ResponseCode.E0, null);
            result.setResponseCode(ResponseCode.E0);
            result.setSuccess(Boolean.valueOf(true));
            result.setData((Object)logid);
            return result;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"/recovery/{instanceActivityLogId}"})
    @ApiOperation(value="\u6309\u7167\u6307\u5b9a\u7684\u6570\u636e\u53d8\u66f4\u65e5\u5fd7\u5bf9\u8868\u5355\u6570\u636e\u8fdb\u884c\u6062\u590d\u3002\u6ce8\u610f\uff1a\u8fd9\u4e2a\u65e5\u5fd7\u5fc5\u987b\u662f\u5f53\u524d\u8868\u5355\u5b9e\u4f8b\u6700\u540e\u4e00\u6b21\u53d8\u52a8\u7684\u65e5\u5fd7", notes="\u5f53\u524d\u65b9\u6cd5\u53ea\u80fd\u6062\u590d\u5f53\u524d\u65e5\u5fd7\u9879\uff0c\u5e76\u4e0d\u63d0\u4f9b\u6570\u636e\u65e5\u5fd7\u4f9d\u636e\u65f6\u95f4\u7ebf\u7684\u6279\u91cf\u6062\u590d")
    public ResponseModel recovery(@PathVariable(value="instanceActivityLogId") String instanceActivityLogId) {
        try {
            JSONObject jsonObject = this.instanceActivityLogService.recoveryByInstanceActivityLogId(instanceActivityLogId);
            return this.buildHttpResultW(jsonObject, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"/recoverys/{targetInstanceActivityId}"})
    @ApiOperation(value="\u57fa\u4e8e\u6307\u5b9a\u7684\u5b9e\u4f8b\u6d3b\u52a8\u7f16\u53f7\uff0c\u5c06\u5bf9\u5e94\u7684\u8868\u5355\u5b9e\u4f8b\u4ece\u6700\u8fd1\u7684\u4e00\u6b21\u53d8\u5316\u65e5\u5fd7\u5f00\u59cb\u8fdb\u884c\u6570\u636e\u6062\u590d\uff0c\u76f4\u5230\u6570\u636e\u6062\u590d\u5230\u8fd9\u4e2a\u6307\u5b9a\u7684\u5b9e\u4f8b\u6d3b\u52a8\u7f16\u53f7\u5bf9\u5e94\u7684\u6700\u540e\u4e00\u6b21\u6570\u636e\u53d8\u5316\u65e5\u5fd7\u4e3a\u6b62\u3002")
    public ResponseModel recoveryByInstanceActivityId(@PathVariable(value="targetInstanceActivityId") String targetInstanceActivityId) {
        try {
            JSONObject jsonObject = this.instanceActivityLogService.recoveryByInstanceActivityId(targetInstanceActivityId);
            return this.buildHttpResultW(jsonObject, new String[0]);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PostMapping(value={"/validateRecoveryByInstanceActivityLogId/{instanceActivityLogId}"})
    @ApiOperation(value="\u6309\u7167\u6307\u5b9a\u7684\u6570\u636e\u53d8\u66f4\u65e5\u5fd7\u5bf9\u8868\u5355\u6570\u636e\u8fdb\u884c\u6062\u590d\u9a8c\u8bc1\u3002", notes="\u6ce8\u610f\uff0c\u8be5\u65b9\u6cd5\u80af\u5b9a\u4f1a\u629b\u51fa\u5f02\u5e38\uff0c\u5982\u679c\u629b\u51fa\u7684\u5f02\u5e38\u65f6\u8fd0\u884c\u65f6\u5f02\u5e38\uff08RuntimeException\u5f02\u5e38\u6216\u8005\u5b50\u7ea7\u5f02\u5e38\uff09\u90a3\u4e48\u8bf4\u660e\u6574\u4e2a\u6062\u590d\u8fc7\u7a0b\u786e\u5b9e\u51fa\u73b0\u4e86\u95ee\u9898")
    public ResponseModel validateRecoveryByInstanceActivityLogId(@PathVariable(value="instanceActivityLogId") String instanceActivityLogId) throws Exception {
        try {
            this.instanceActivityLogService.validateRecoveryByInstanceActivityLogId(instanceActivityLogId);
        }
        catch (IllegalStateException e) {
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
        return this.buildHttpResult();
    }

    @PostMapping(value={"/validateRecoveryByInstanceActivityId/{targetInstanceActivityId}"})
    @ApiOperation(value="\u57fa\u4e8e\u6307\u5b9a\u7684\u5b9e\u4f8b\u6d3b\u52a8\u7f16\u53f7\uff0c\u5c06\u5bf9\u5e94\u7684\u8868\u5355\u5b9e\u4f8b\u4ece\u6700\u8fd1\u7684\u4e00\u6b21\u53d8\u5316\u65e5\u5fd7\u5f00\u59cb\u8fdb\u884c\u6570\u636e\u6062\u590d\u3002", notes="\u6ce8\u610f\uff0c\u8be5\u65b9\u6cd5\u80af\u5b9a\u4f1a\u629b\u51fa\u5f02\u5e38\uff0c\u5982\u679c\u629b\u51fa\u7684\u5f02\u5e38\u65f6\u8fd0\u884c\u65f6\u5f02\u5e38\uff08RuntimeException\u5f02\u5e38\u6216\u8005\u5b50\u7ea7\u5f02\u5e38\uff09\u90a3\u4e48\u8bf4\u660e\u6574\u4e2a\u6062\u590d\u8fc7\u7a0b\u786e\u5b9e\u51fa\u73b0\u4e86\u95ee\u9898")
    public ResponseModel validateRecoveryByInstanceActivityId(@PathVariable(value="targetInstanceActivityId") String targetInstanceActivityId) throws Exception {
        try {
            this.instanceActivityLogService.validateRecoveryByInstanceActivityId(targetInstanceActivityId);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
        catch (Exception e) {
            return this.buildHttpResult();
        }
        return this.buildHttpResult();
    }
}

