/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.MigrateExportEntity;
import com.bizunited.platform.kuiper.starter.service.migrate.MigrateExportService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="MigrateExportController")
@RequestMapping(value={"/v1/kuiper/migrateExports"})
@RestController(value="kuiperMigrateExportController")
public class MigrateExportController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrateExportController.class);
    @Autowired
    private MigrateExportService migrateExportService;

    @GetMapping(value={"findDetailsByDataType"})
    @ApiOperation(value="\u6839\u636e\u6570\u636e\u7c7b\u578b\u67e5\u8be2\u5bfc\u51fa\u65e5\u5fd7")
    public ResponseModel findDetailsByDataType(Integer dataType) {
        try {
            List<MigrateExportEntity> exports = this.migrateExportService.findDetailsByDataType(dataType);
            return this.buildHttpResultW(exports, new String[]{"createUser"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"exportListTempate"})
    @ApiOperation(value="\u5bfc\u51fa\u5217\u8868\u6a21\u7248\u6570\u636e")
    public void exportListTempate(@RequestParam(value="ids", required=false) @ApiParam(value="\u6570\u636eID\u96c6\u5408") String[] ids, HttpServletRequest request, HttpServletResponse response) {
        try {
            byte[] bytes = this.migrateExportService.exportListTempate(ids);
            Validate.isTrue((boolean)ArrayUtils.isNotEmpty((byte[])bytes), (String)"\u6ca1\u6709\u4efb\u4f55\u4e0b\u8f7d\u4fe1\u606f\uff0c\u5f88\u5927\u51e0\u7387\u539f\u56e0\u662f\u5bfc\u51fa\u903b\u8f91\u51fa\u73b0\u9519\u8bef!!", (Object[])new Object[0]);
            String time = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            String fileName = StringUtils.join((Object[])new String[]{"\u5217\u8868\u6a21\u7248-", time, ".", "zip"});
            this.writeResponseFile(request, response, bytes, fileName);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.printResponseModel(this.buildHttpResultForException(e), response);
        }
    }

    @GetMapping(value={"exportPageFlow"})
    @ApiOperation(value="\u5bfc\u51fa\u9875\u9762\u6d41\u6570\u636e")
    public void exportPageFlow(@RequestParam(value="ids", required=false) @ApiParam(value="\u6570\u636eID\u96c6\u5408") String[] ids, HttpServletRequest request, HttpServletResponse response) {
        try {
            byte[] bytes = this.migrateExportService.exportPageFlow(ids);
            Validate.isTrue((boolean)ArrayUtils.isNotEmpty((byte[])bytes), (String)"\u6ca1\u6709\u4efb\u4f55\u4e0b\u8f7d\u4fe1\u606f\uff0c\u5f88\u5927\u51e0\u7387\u539f\u56e0\u662f\u5bfc\u51fa\u903b\u8f91\u51fa\u73b0\u9519\u8bef!!", (Object[])new Object[0]);
            String time = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            String fileName = StringUtils.join((Object[])new String[]{"\u9875\u9762\u6d41-", time, ".", "zip"});
            this.writeResponseFile(request, response, bytes, fileName);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.printResponseModel(this.buildHttpResultForException(e), response);
        }
    }

    @ApiOperation(value="\u5bfc\u51fa\u8868\u5355\u6a21\u7248\u6570\u636e")
    @GetMapping(value={"exportFormTemplate"})
    public void exportFormTemplate(@RequestParam(value="ids", required=false) @ApiParam(value="\u6570\u636eID\u96c6\u5408") String[] ids, HttpServletRequest request, HttpServletResponse response) {
        try {
            byte[] bytes = this.migrateExportService.exportFormTemplate(ids);
            Validate.isTrue((boolean)ArrayUtils.isNotEmpty((byte[])bytes), (String)"\u6ca1\u6709\u4efb\u4f55\u4e0b\u8f7d\u4fe1\u606f\uff0c\u5f88\u5927\u51e0\u7387\u539f\u56e0\u662f\u5bfc\u51fa\u903b\u8f91\u51fa\u73b0\u9519\u8bef!!", (Object[])new Object[0]);
            String time = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            String fileName = StringUtils.join((Object[])new String[]{"\u8868\u5355\u6a21\u7248-", time, ".", "zip"});
            this.writeResponseFile(request, response, bytes, fileName);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.printResponseModel(this.buildHttpResultForException(e), response);
        }
    }

    @ApiOperation(value="\u4f20\u5165\u5bfc\u51fa\u7684\u51fd\u6570ID\u5219\u6309\u7167\u4f20\u5165\u7684\u6570\u636eID\u6765\u5bfc\u51fa\uff0c\u5426\u5219\u5bfc\u51fa\u5168\u90e8")
    @GetMapping(value={"/exportFrontFile"})
    public void exportFrontFile(@ApiParam(name="frontFileIds", value="\u6307\u5b9a\u5bfc\u51fa\u7684\u9875\u9762\u51fd\u6570ID\u96c6\u5408", required=false) @RequestParam(name="frontFileIds", required=false) String[] frontFileIds, HttpServletRequest request, HttpServletResponse response) {
        try {
            byte[] bytes = this.migrateExportService.exportFrontFile(frontFileIds);
            Validate.isTrue((bytes != null && bytes.length != 0 ? 1 : 0) != 0, (String)"\u6ca1\u6709\u4efb\u4f55\u4e0b\u8f7d\u4fe1\u606f\uff0c\u5f88\u5927\u51e0\u7387\u539f\u56e0\u662f\u5bfc\u51fa\u903b\u8f91\u51fa\u73b0\u9519\u8bef!!", (Object[])new Object[0]);
            String time = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
            String fileName = StringUtils.join((Object[])new String[]{"\u9875\u9762\u51fd\u6570-", time, ".", "zip"});
            this.writeResponseFile(request, response, bytes, fileName);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            this.printResponseModel(this.buildHttpResultForException(e), response);
        }
    }
}

