/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.PageEventEntity;
import com.bizunited.platform.kuiper.starter.service.PageEventService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={" \u9875\u9762\u4e8b\u4ef6\u63a7\u5236\u7c7b"})
@RequestMapping(value={"/v1/kuiper/page/events"})
public class PageEventController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageEventController.class);
    @Autowired
    private PageEventService pageEventService;

    @GetMapping(value={"findByPage"})
    @ApiOperation(value="\u6839\u636e\u9875\u9762ID\u67e5\u8be2")
    public ResponseModel findByPage(@RequestParam @ApiParam(value="\u9875\u9762ID", required=true) String pageId) {
        try {
            Set<PageEventEntity> events = this.pageEventService.findByPageId(pageId);
            return this.buildHttpResultW(events, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findDetailsByPage"})
    @ApiOperation(value="\u6839\u636e\u9875\u9762ID\u67e5\u8be2\u8be6\u60c5")
    public ResponseModel findDetailsByPage(@RequestParam @ApiParam(value="\u9875\u9762ID", required=true) String pageId) {
        try {
            Set<PageEventEntity> events = this.pageEventService.findDetailsByPageId(pageId);
            return this.buildHttpResultW(events, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findDetailById"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u8be6\u60c5")
    public ResponseModel findDetailById(@RequestParam @ApiParam(value="\u4e3b\u952eID", required=true) String id) {
        try {
            PageEventEntity event = this.pageEventService.findDetailById(id);
            return this.buildHttpResultW(event, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findDetailByPageFlowCodeAndPageCodeAndEventId"})
    @ApiOperation(value="\u6839\u636e\u9875\u9762\u6d41\u7f16\u7801\u548c\u9875\u9762\u7f16\u7801\u548c\u4e8b\u4ef6ID\u67e5\u8be2")
    public ResponseModel findDetailByPageFlowCodeAndPageCodeAndEventId(@RequestParam @ApiParam(value="\u9875\u9762\u6d41\u7f16\u7801", required=true) String pageFlowCode, @RequestParam @ApiParam(value="\u9875\u9762\u7f16\u7801", required=true) String pageCode, @RequestParam @ApiParam(value="\u4e8b\u4ef6ID", required=true) String eventId) {
        try {
            PageEventEntity event = this.pageEventService.findDetailByPageFlowCodeAndPageCodeAndEventId(pageFlowCode, pageCode, eventId);
            return this.buildHttpResultW(event, new String[]{"page", "page.pageFlow"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

