/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.PageFlowEntity;
import com.bizunited.platform.kuiper.starter.service.PageFlowService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="PageFlowController", tags={"\u9875\u9762\u6d41\u529f\u80fd\u4e1a\u52a1\u6a21\u578b\u7684MVC Controller\u5c42\u5b9e\u73b0"})
@RestController
@RequestMapping(value={"/v1/kuiper/pageFlows"})
public class PageFlowController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(PageFlowController.class);
    @Autowired
    private PageFlowService pageFlowService;
    private static final String[] PAGE_FLOW_PROPERTIES_W = new String[]{"pages", "createUser", "modifyUser", "pages.events"};

    @PostMapping(value={""})
    @ApiOperation(value="\u521b\u5efa\u9875\u9762\u6d41", notes="\u521b\u5efa\u9875\u9762\u6d41")
    public ResponseModel create(@RequestBody PageFlowEntity pageFlow) {
        try {
            Principal principal = this.getPrincipal();
            PageFlowEntity result = this.pageFlowService.create(pageFlow, principal);
            return this.buildHttpResultW(result, PAGE_FLOW_PROPERTIES_W);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @PatchMapping(value={""})
    @ApiOperation(value="\u66f4\u65b0\u9875\u9762\u6d41", notes="\u66f4\u65b0\u9875\u9762\u6d41")
    public ResponseModel update(@RequestBody PageFlowEntity pageFlow) {
        try {
            Principal principal = this.getPrincipal();
            PageFlowEntity result = this.pageFlowService.update(pageFlow, principal);
            return this.buildHttpResultW(result, PAGE_FLOW_PROPERTIES_W);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findById"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u9875\u9762\u6d41\u4fe1\u606f\uff08\u6ce8\u610f\u53ea\u6709\u57fa\u672c\u4fe1\u606f\uff0c\u4e0d\u5305\u62ec\u4efb\u4f55\u7684\u5173\u8054\u4fe1\u606f\uff09", notes="\u6839\u636eID\u67e5\u8be2\u9875\u9762\u6d41\u4fe1\u606f\uff08\u6ce8\u610f\u53ea\u6709\u57fa\u672c\u4fe1\u606f\uff0c\u4e0d\u5305\u62ec\u4efb\u4f55\u7684\u5173\u8054\u4fe1\u606f\uff09")
    public ResponseModel findById(@ApiParam(name="id", value="\u9875\u9762\u6d41ID", required=true) @RequestParam(value="id") String id) {
        try {
            PageFlowEntity result = this.pageFlowService.findById(id);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findDetailsById"})
    @ApiOperation(value="\u6309\u7167\u6570\u9875\u9762\u6d41ID\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u542b\u9875\u9762\u6d41\u4e0b\u7684\u6240\u6709\u5173\u8054\u4fe1\u606f")
    public ResponseModel findDetailsById(@ApiParam(value="\u9875\u9762\u6d41ID", required=true) @RequestParam(value="id") String id) {
        try {
            PageFlowEntity result = this.pageFlowService.findDetailsById(id);
            return this.buildHttpResultW(result, PAGE_FLOW_PROPERTIES_W);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByCode"})
    @ApiOperation(value="\u6839\u636e\u7f16\u7801\u67e5\u8be2\u9875\u9762\u6d41\u4fe1\u606f, \u4e0d\u5305\u542b\u5173\u8054\u4fe1\u606f", notes="\u6839\u636e\u7f16\u7801\u67e5\u8be2\u9875\u9762\u6d41\u4fe1\u606f, \u4e0d\u5305\u542b\u5173\u8054\u4fe1\u606f")
    public ResponseModel findByCode(@RequestParam(value="code") @ApiParam(value="\u6307\u5b9a\u7684\u9875\u9762\u6d41\u7f16\u7801", required=true) String code) {
        try {
            PageFlowEntity result = this.pageFlowService.findByCode(code);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findDetailsByCode"})
    @ApiOperation(value="\u6309\u7167\u6570\u9875\u9762\u6d41\u7f16\u7801\u8fdb\u884c\u67e5\u8be2\u660e\u7ec6\u67e5\u8be2\uff0c\u67e5\u8be2\u7684\u660e\u7ec6\u5305\u542b\u9875\u9762\u6d41\u4e0b\u7684\u6240\u6709\u5173\u8054\u4fe1\u606f")
    public ResponseModel findDetailsByCode(@ApiParam(name="code", value="\u6307\u5b9a\u7684\u9875\u9762\u6d41\u7f16\u7801", required=true) @RequestParam(value="code") String code) {
        try {
            PageFlowEntity result = this.pageFlowService.findDetailsByCode(code);
            return this.buildHttpResultW(result, PAGE_FLOW_PROPERTIES_W);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @GetMapping(value={"findByConditions"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2,\u652f\u6301\u6a21\u7cca\u67e5\u8be2", notes="\u9875\u6570\u53c2\u6570\u4e3apage\uff0c\u7b2c\u4e00\u9875\u4ece0\u5f00\u59cb\uff0c\u5206\u9875\u5927\u5c0f\u53c2\u6570\u4e3asize\uff08size\u9ed8\u8ba4\u4e3a50\uff09")
    public ResponseModel findByConditions(@PageableDefault(value=50) Pageable pageable, @ApiParam(name="name", value="\u9875\u9762\u6d41\u540d\u79f0") @RequestParam(value="name", required=false) String name, @ApiParam(name="code", value="\u9875\u9762\u6d41\u7f16\u7801") @RequestParam(value="code", required=false) String code) {
        try {
            PageFlowEntity pageFlow = new PageFlowEntity();
            pageFlow.setName(name);
            pageFlow.setCode(code);
            Page<PageFlowEntity> result = this.pageFlowService.findByConditions(pageFlow, pageable);
            return this.buildHttpResultW(result, new String[]{"pages"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636e\u4e3b\u952e\u5220\u9664\u9875\u9762\u6d41\u4ee5\u53ca\u5173\u8054\u4fe1\u606f")
    public ResponseModel deleteById(@ApiParam(value="\u4e3b\u952e", required=true) @PathVariable(value="id") String id) {
        try {
            this.pageFlowService.deleteById(id);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

