/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.service.StaticTemplateService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="StaticTemplateController")
@RestController
@RequestMapping(value={"/v1/kuiper/staticTemplates"})
public class StaticTemplateController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticTemplateController.class);
    @Autowired
    private StaticTemplateService staticTemplateService;

    @ApiOperation(value="\u8be5\u65b9\u6cd5\u7528\u4e8e\u57fa\u4e8esaturn\u626b\u63cf\u7ec4\u4ef6\u4e2d\u5df2\u626b\u63cf\u786e\u5b9a\u7684\u67d0\u4e00\u4e2a\u9759\u6001\u6a21\u578b\uff08\u5b8c\u6574\u7684\u9759\u6001\u6a21\u578b\u7c7b\u540d\uff09\uff0c\u5b8c\u6210\u4e00\u4e2a\u9759\u6001\u8868\u5355\u6a21\u677f\u7684\u521d\u59cb\u5316\u8fc7\u7a0b\u8fd9\u4e2a\u8fc7\u7a0b\u4e00\u822c\u53d1\u751f\u5728\u64cd\u4f5c\u4eba\u5458\u901a\u8fc7\u9875\u9762\u4e0a\u7684\u201c\u521b\u5efa\u9759\u6001\u8868\u5355\u6a21\u677f\u201d\u529f\u80fd\u9009\u5b9a\u4e00\u4e2a\u9759\u6001\u6a21\u578b\uff0c\u5e76\u70b9\u51fb\u201c\u521b\u5efa\u201d\u6309\u94ae\u65f6\u53d1\u751f\u3002 \u901a\u8fc7\u8fd9\u4e2a\u65b9\u6cd5\uff0c\u7cfb\u7edf\u5c06\u8fd4\u56de\u8fd9\u4e2a\u9759\u6001\u6a21\u578b\u7684\u521d\u59cb\u5316\u4fe1\u606f\u3002\u521d\u59cb\u5316\u4fe1\u606f\u5305\u62ec\u9759\u6001\u6a21\u578b\u672c\u8eab\u7684\u63cf\u8ff0\uff0c\u8fd8\u5305\u62ec\u9759\u6001\u6a21\u578b\u5173\u8054\u7684\u4e00\u822c\u5c5e\u6027\u3001\u5173\u8054\u5c5e\u6027\uff0c\u4ee5\u53ca\u5173\u8054\u5c5e\u6027\u4e2dOneToMany\u6027\u8d28\u5173\u8054\u7684\u4e0b\u4e00\u7ea7\u5c5e\u6027\u7b49\u4fe1\u606f\u4ee5\u53ca\u6839\u636e\u9759\u6001\u6a21\u578b\u5173\u8054\u60c5\u51b5\u521d\u59cb\u5316\u5b8c\u6210\u7684\u201c\u9759\u6001\u670d\u52a1\u6e90\u201d\u4fe1\u606f\u2014\u2014\u5f53\u7136\u4e5f\u5305\u62ec\u4e86\u76f4\u63a5\u5173\u8054\u7684\u670d\u52a1\u6e90\u548cOneToMany\u5173\u7cfb\u4e2d\u5173\u8054\u7684\u670d\u52a1\u6e90\u3002", notes="\u8bf7\u6ce8\u610f\uff0c\u8fd9\u91cc\u5e76\u4e0d\u662f\u8fd4\u56dePersistentClass\u5bf9\u8c61\u7684json\u7ed3\u6784\uff0c\u800c\u662f\u4e00\u4e2a\u6ee1\u8db3\u6280\u672f\u767d\u76ae\u4e66\u4e2d\u9759\u6001\u6a21\u578b\u7ed3\u6784\u5b9a\u4e49\u7684JSON\u7ed3\u6784\u3002\u8be6\u7ec6\u60c5\u51b5\u53ef\u53c2\u89c1\u300a\u8868\u5355\u5f15\u64ce\u6280\u672f\u767d\u76ae\u4e66V1.1\u300b\u767d\u76ae\u4e66\u6587\u6863\u4e2d\u7684\u63cf\u8ff0")
    @PostMapping(value={"/initStaticTemplate"})
    @CacheEvict(cacheNames={"template"}, allEntries=true)
    public ResponseModel initStaticTemplate(@RequestBody @ApiParam(name="template", value="\u65b0\u7684\u8868\u5355\u6a21\u677f\u4fe1\u606f\uff0c\u81f3\u5c11\u8bf4\u660e\u7248\u672c\u4fe1\u606f\u3001\u6a21\u677f\u7c7b\u578b\u3001\u5df2\u7ecf\u4f7f\u7528\u7684\u9759\u6001\u7c7b\u5168\u540d\uff0c\u5176\u5b83\u4e0d\u9700\u8981\u6307\u5b9a\u4e86") TemplateEntity template) {
        try {
            Principal principal = this.getPrincipal();
            TemplateEntity result = this.staticTemplateService.initStaticTemplate(template, principal, true);
            return this.buildHttpResultW(result, new String[]{"properties", "relations", "creator", "groupRelations", "groupRelations.properties", "groupRelations.relations", "groupRelations.itemRelations", "groupRelations.itemRelations.properties", "groupRelations.itemRelations.relations", "itemRelations", "itemRelations.properties", "itemRelations.relations", "event", "visibility", "visibility.attributes", "visibility.buttons"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5bf9\u6307\u5b9a\u7684\u8868\u5355\u6a21\u677f\u8fdb\u884c\u5347\u7ea7\u5904\u7406\uff0c\u901a\u8fc7\u8fd9\u4e2a\u63a5\u53e3\u670d\u52a1\u7cfb\u7edf\u5c06\u81ea\u52a8\u4fdd\u7559templateId\u5bf9\u5e94\u7684\u6a21\u677f\u7684\u5168\u90e8\u4e3b\u8981\u8bbe\u5b9a\uff08\u5305\u62ec\u6a21\u578b\u3001\u6570\u636e\u6e90\u3001\u4e8b\u4ef6\u3001\u53ef\u89c1\u6027\uff09", notes="\u5728\u53ea\u66f4\u6539\u6a21\u677f\u57fa\u672c\u4fe1\u606f\uff0c\u7248\u672c\u4fe1\u606f\u7684\u60c5\u51b5\u4e0b\uff0c\u62f7\u8d1d\u51fa\u4e00\u4e2a\u65b0\u7684\u6a21\u677f")
    @PutMapping(value={""})
    @CacheEvict(cacheNames={"template"}, allEntries=true)
    public ResponseModel upgrade(@ApiParam(name="templateId", value="\u6307\u5b9a\u7684\u8868\u5355\u6a21\u677f\u5347\u7ea7\u65f6\u4f7f\u7528\u7684\u53c2\u8003\u6a21\u677f") @RequestParam(name="templateId") String templateId, @ApiParam(name="newVersion", value="\u65b0\u7684\u7248\u672c\u53f7") @RequestParam(name="newVersion") String newVersion, @ApiParam(value="\u66f4\u65b0\u6a21\u7248\u5b9e\u4f8b\u4f7f\u7528\u5f53\u524d\u6a21\u7248\u7248\u672c") @RequestParam(name="updateInstance", required=false, defaultValue="0") Boolean updateInstance) {
        try {
            Principal principal = this.getPrincipal();
            TemplateEntity result = this.staticTemplateService.upgradeStaticTemplate(templateId, newVersion, updateInstance.booleanValue(), principal);
            return this.buildHttpResultW(result, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5220\u9664\u6307\u5b9a\u7684\u6a21\u677f\u4fe1\u606f\uff0c\u771f\u5220\u9664\u2014\u2014\u5305\u62ec\u6a21\u677f\u7684\u53ef\u89c1\u6027\u3001\u6a21\u677f\u7684\u4e8b\u4ef6\u3001\u6a21\u677f\u7684\u6570\u636e\u6e90\u7b49\u4fe1\u606f\u3002", notes="\u5df2\u7ecf\u5b58\u5728\u5b9e\u4f8b\u5728\u8fd0\u884c\u7684\u6a21\u677f\u4fe1\u606f\uff0c\u662f\u4e0d\u5141\u8bb8\u8fdb\u884c\u5220\u9664\u7684")
    @DeleteMapping(value={""})
    @CacheEvict(cacheNames={"template"}, allEntries=true)
    public ResponseModel deleteById(@ApiParam(name="id", value="\u8868\u5355\u6a21\u677f\u7684\u6570\u636e\u5e93\u7f16\u53f7") String id) {
        try {
            this.staticTemplateService.deleteById(id);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u5bf9\u6307\u5b9a\u7684\u4e0d\u540c\u7248\u672c\uff0c\u76f8\u540c\u6a21\u578b\u5b9a\u4e49\u7684\u4e24\u4e2a\u8868\u5355\u6a21\u677f\u8fdb\u884c\u5408\u5e76\u5904\u7406\uff0c\u901a\u8fc7\u8fd9\u4e2a\u63a5\u53e3\u670d\u52a1\u7cfb\u7edf\u5c06\u81ea\u52a8\u751f\u6210\u4e00\u4e2a\u65b0\u7684\u8868\u5355\u6a21\u677f\u3002", notes="\u4ee5\u5176\u4e2d\u4e00\u4e2a\u6a21\u677f\u4e3a\u57fa\u51c6\uff0c\u53e6\u4e00\u4e2a\u6a21\u677f\u7684\u4fe1\u606f\u4f1a\u5408\u5e76\u5230\u57fa\u51c6\u6a21\u677f\u4e2d\uff0c\u4ece\u800c\u751f\u6210\u4e00\u4e2a\u65b0\u7684\u6a21\u677f")
    @PostMapping(value={"/merge"})
    @CacheEvict(cacheNames={"template"}, allEntries=true)
    public ResponseModel merge(@ApiParam(name="refTemplateId", value="\u6307\u5b9a\u7684\u57fa\u51c6\u8868\u5355\u6a21\u677fid") String refTemplateId, @ApiParam(name="templateId", value="\u5f85\u5408\u5e76\u6a21\u677fid") String templateId, @ApiParam(name="name", value="\u5b9a\u4e49\u7684\u65b0\u6a21\u677f\u7684\u540d\u79f0") String name, @ApiParam(name="version", value="\u5b9a\u4e49\u7684\u65b0\u6a21\u677f\u7684\u7248\u672c") String version) {
        try {
            Principal principal = this.getPrincipal();
            this.staticTemplateService.merge(refTemplateId, templateId, name, version, principal);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

