/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.TemplateMaintainerEntity;
import com.bizunited.platform.kuiper.starter.service.TemplateMaintainerService;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(value="TemplateMaintainerController")
@RestController
@RequestMapping(value={"/v1/kuiper/templates/maintainer"})
public class TemplateMaintainerController
extends BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateMaintainerController.class);
    @Value(value="${rbac.template.maintainers}")
    private String[] maintainerAccounts;
    @Autowired
    private TemplateMaintainerService templateMaintainerService;

    @ApiOperation(value="\u5177\u6709\u6388\u6743\u6743\u9650\u7684\u4eba\uff0c\u6388\u6743\u7528\u6237\u80fd\u7ef4\u62a4\u5176\u4ed6\u7528\u6237\u521b\u5efa\u7684\u6a21\u677f")
    @PatchMapping(value={"/binding"})
    public ResponseModel updateMaintainers(@ApiParam(name="code", value="\u6307\u5b9a\u7684\u6a21\u677fcode") @RequestParam(name="code") String code, @ApiParam(name="maintainers", value="\u7ef4\u62a4\u4eba\u5458\u7684\u8d26\u53f7\u4fe1\u606f(\u6570\u7ec4)") @RequestBody String[] maintainers) {
        try {
            Principal principal = this.getPrincipal();
            this.templateMaintainerService.binding(code, maintainers, this.maintainerAccounts, principal);
            return this.buildHttpResult();
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u83b7\u53d6\u914d\u7f6e\u6587\u4ef6\u4e2d\u8bbe\u7f6e\u7684\uff0c\u5177\u6709\u6388\u6743\u53d8\u66f4\u6a21\u677f\u4fe1\u606f\u7684\u4eba\u5458")
    @GetMapping(value={"/loadAuthorProps"})
    public ResponseModel findAuthorMaintainers() {
        try {
            if (ArrayUtils.isEmpty((Object[])this.maintainerAccounts)) {
                this.maintainerAccounts = new String[]{"admin"};
            }
            ArrayList maintainerAccountList = Lists.newArrayList((Object[])this.maintainerAccounts);
            return this.buildHttpResultW(maintainerAccountList, new String[0]);
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }

    @ApiOperation(value="\u6839\u636e\u6a21\u7248ID\u67e5\u8be2\u8be6\u60c5\u4fe1\u606f")
    @GetMapping(value={"findDetailsByTemplateId"})
    public ResponseModel findDetailsByTemplateId(@RequestParam @ApiParam(value="\u6a21\u7248ID") String templateId) {
        try {
            Set<TemplateMaintainerEntity> maintainer = this.templateMaintainerService.findDetailsByTemplateId(templateId);
            return this.buildHttpResultW(maintainer, new String[]{"user", "template"});
        }
        catch (RuntimeException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return this.buildHttpResultForException(e);
        }
    }
}

