/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.repository;

import com.bizunited.platform.kuiper.entity.PageEntity;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="PageRepository")
public interface PageRepository
extends JpaRepository<PageEntity, String>,
JpaSpecificationExecutor<PageEntity> {
    @Query(value="select p from PageEntity p inner join fetch p.pageFlow pf left join fetch p.events where pf.id = :pageFlowId ")
    public Set<PageEntity> findDetailsByPageFlowId(@Param(value="pageFlowId") String var1);

    @Query(value="from PageEntity p inner join fetch p.pageFlow pf left join fetch p.events where p.code = :code and pf.code = :pageFlowCode ")
    public PageEntity findDetailsByCodeAndPageFlowCode(@Param(value="code") String var1, @Param(value="pageFlowCode") String var2);

    @Query(value="select p from PageEntity p inner join fetch p.pageFlow pf left join fetch p.events where pf.code = :pageFlowCode ")
    public Set<PageEntity> findDetailsByPageFlowCode(@Param(value="pageFlowCode") String var1);

    @Query(value="from PageEntity p inner join fetch p.pageFlow pf left join fetch p.events where p.id = :id")
    public PageEntity findDetailsById(@Param(value="id") String var1);

    @Query(value="select p from PageEntity p inner join p.pageFlow pf  where pf.code = :pageFlowCode ")
    public Set<PageEntity> findByPageFlowCode(@Param(value="pageFlowCode") String var1);

    @Modifying
    @Query(value="delete from engine_form_page where page_flow_id = :pageFlowId ", nativeQuery=true)
    public void deleteByPageFlowId(@Param(value="pageFlowId") String var1);
}

