/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.repository;

import com.bizunited.platform.kuiper.entity.TemplateVisibilityEntity;
import java.util.Set;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository(value="TemplateVisibilityRepository")
public interface TemplateVisibilityRepository
extends JpaRepository<TemplateVisibilityEntity, String>,
JpaSpecificationExecutor<TemplateVisibilityEntity> {
    @Query(value="select tve from TemplateVisibilityEntity tve left join fetch tve.template t left join fetch tve.attributes tva left join fetch tve.buttons tvb where t.id = :templateId  order by tve.createTime")
    public Set<TemplateVisibilityEntity> findDetailsByTemplateId(@Param(value="templateId") String var1);

    @Query(value="select tve from TemplateVisibilityEntity tve left join fetch tve.template t left join fetch tve.attributes tva left join fetch tve.buttons tvb where t.id in (:templateIds) ")
    public Set<TemplateVisibilityEntity> findDetailsByTemplateIds(@Param(value="templateIds") Set<String> var1);

    @Query(value="from TemplateVisibilityEntity tv where tv.template.id = :templateId order by tv.createTime ")
    public Set<TemplateVisibilityEntity> findByTemplateId(@Param(value="templateId") String var1);

    @Query(value="from TemplateVisibilityEntity tv inner join fetch tv.template t where t.id = :templateId and tv.visibilityName = :visibilityName ")
    public TemplateVisibilityEntity findByTemplateIdAndVisibilityName(@Param(value="templateId") String var1, @Param(value="visibilityName") String var2);

    @Query(value="select count(*) from engine_form_visibility et where et.template_id = :templateId and et.visibility_name = :visibilityName ", nativeQuery=true)
    public int countVisibilityName(@Param(value="templateId") String var1, @Param(value="visibilityName") String var2);

    @Query(value="select tve from TemplateVisibilityEntity tve left join fetch tve.template t left join fetch tve.attributes tva where t.id = :templateId and tva.layoutType = :layoutType  order by tve.createTime")
    public Set<TemplateVisibilityEntity> findVisibilityAndAttributesByTemplateIdAndLayoutType(@Param(value="templateId") String var1, @Param(value="layoutType") Integer var2);

    @Query(value="select tve from TemplateVisibilityEntity tve left join fetch tve.template t left join fetch tve.buttons tvb where t.id = :templateId and tvb.layoutType = :layoutType  order by tve.createTime")
    public Set<TemplateVisibilityEntity> findVisibilityAndButtonsByTemplateIdAndLayoutType(@Param(value="templateId") String var1, @Param(value="layoutType") Integer var2);

    @Query(value="select tv from TemplateVisibilityEntity tv inner join tv.template t where t.code = :templateCode and t.cversion = :version  order by tv.createTime asc")
    public Set<TemplateVisibilityEntity> findByTemplateCodeAndVersion(@Param(value="templateCode") String var1, @Param(value="version") String var2);

    @Query(value="select tv from TemplateVisibilityEntity tv inner join tv.template t where t.code = :templateCode and t.defaultVersion = 1  order by tv.createTime asc")
    public Set<TemplateVisibilityEntity> findByTemplateCodeAndDefaultVersion(@Param(value="templateCode") String var1);
}

