/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.repository.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.kuiper.entity.FrontFileEntity;
import com.bizunited.platform.kuiper.starter.repository.internal.FrontFileRepositoryCustom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="FrontFileRepositoryImpl")
public class FrontFileRepositoryImpl
implements FrontFileRepositoryCustom {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private PlatformContext platformContext;
    private static final String FILE_CLASSIFY = "fileClassify";
    private static final String FILE_STATUS = "fileStatus";

    @Override
    public Page<FrontFileEntity> queryPage(Pageable pageable, Map<String, Object> conditions) {
        Object fileStatus;
        Object fileClassify;
        String hql = "from FrontFileEntity front where 1=1 ";
        String countSql = "select count(*) from FrontFileEntity front where 1=1 ";
        hql = hql + " and front.projectName=:projectName ";
        countSql = countSql + " and front.projectName=:projectName ";
        Object name = conditions.get("name");
        if (name != null) {
            hql = hql + " AND front.name = :name ";
            countSql = countSql + " AND front.name = :name ";
        }
        if ((fileClassify = conditions.get(FILE_CLASSIFY)) != null) {
            hql = hql + " AND front.fileClassify = :fileClassify ";
            countSql = countSql + " AND front.fileClassify = :fileClassify ";
        }
        if ((fileStatus = conditions.get(FILE_STATUS)) != null) {
            hql = hql + " AND front.fileStatus = :fileStatus ";
            countSql = countSql + " AND front.fileStatus = :fileStatus ";
        }
        hql = hql + " order by front.createTime desc ";
        Query query = this.entityManager.createQuery(hql);
        Query countQuery = this.entityManager.createQuery(countSql);
        query.setParameter("projectName", (Object)this.platformContext.getAppName());
        countQuery.setParameter("projectName", (Object)this.platformContext.getAppName());
        if (name != null) {
            query.setParameter("name", name);
            countQuery.setParameter("name", name);
        }
        if (fileClassify != null) {
            query.setParameter(FILE_CLASSIFY, fileClassify);
            countQuery.setParameter(FILE_CLASSIFY, fileClassify);
        }
        if (fileStatus != null) {
            query.setParameter(FILE_STATUS, fileStatus);
            countQuery.setParameter(FILE_STATUS, fileStatus);
        }
        query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
        query.setMaxResults(pageable.getPageSize());
        List resutls = query.getResultList();
        Long count = (Long)countQuery.getResultList().get(0);
        return new PageImpl(resutls, pageable, count.longValue());
    }

    @Override
    public List<FrontFileEntity> findAllByConditions(Map<String, Object> conditions) {
        Object fileStatus;
        String fileClassify;
        StringBuilder hql = new StringBuilder("from FrontFileEntity front where 1=1 ");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        String name = (String)conditions.get("name");
        if (StringUtils.isNotBlank((CharSequence)name)) {
            hql.append(" AND front.name = :name");
            parameters.put("name", name);
        }
        if (StringUtils.isNotBlank((CharSequence)(fileClassify = (String)conditions.get(FILE_CLASSIFY)))) {
            hql.append(" AND front.fileClassify = :fileClassify ");
            parameters.put(FILE_CLASSIFY, fileClassify);
        }
        if ((fileStatus = conditions.get(FILE_STATUS)) != null) {
            hql.append(" AND front.fileStatus = :fileStatus ");
            parameters.put(FILE_STATUS, fileStatus);
        }
        hql.append(" order by front.createTime desc ");
        Query query = this.entityManager.createQuery(hql.toString());
        parameters.forEach((k, v) -> query.setParameter(k, v));
        return query.getResultList();
    }
}

