/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.repository.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.kuiper.entity.ListTemplateEntity;
import com.bizunited.platform.kuiper.starter.repository.internal.ListTemplateRepositoryCustom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository(value="ListTemplateRepositoryImpl")
public class ListTemplateRepositoryImpl
implements ListTemplateRepositoryCustom,
PageRepositoryImpl {
    @Autowired
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private PlatformContext platformContext;
    private static final String CVERSION = "cversion";
    private static final String MESS_MODIFY_START = "modifyStart";
    private static final String MESS_MODIFY_END = "modifyEnd";

    @Override
    public Page<ListTemplateEntity> findByConditions(Pageable pageable, Map<String, Object> conditions) {
        String projectName;
        Object modifyEnd;
        Object modifyStart;
        Object name;
        Object cversion;
        StringBuilder hql = new StringBuilder("from ListTemplateEntity le where 1= 1  ");
        StringBuilder countHql = new StringBuilder("select count(*) from ListTemplateEntity le where 1 = 1 ");
        hql.append(" and le.projectName=:projectName ");
        countHql.append(" and le.projectName=:projectName ");
        StringBuilder condition = new StringBuilder();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Boolean defaultVersion = (Boolean)conditions.get("defaultVersion");
        if (defaultVersion != null) {
            condition.append(" AND le.defaultVersion = :defaultVersion");
            parameters.put("defaultVersion", defaultVersion);
        }
        parameters.put("projectName", this.platformContext.getAppName());
        Object code = conditions.get("code");
        if (code != null) {
            condition.append(" AND le.code like CONCAT('%', :code, '%')");
            parameters.put("code", code);
        }
        if ((cversion = conditions.get(CVERSION)) != null) {
            condition.append(" AND le.cversion = :cversion ");
            parameters.put(CVERSION, cversion);
        }
        if ((name = conditions.get("name")) != null) {
            condition.append(" AND le.name like CONCAT('%', :name, '%')");
            parameters.put("name", name);
        }
        if ((modifyStart = conditions.get(MESS_MODIFY_START)) != null) {
            condition.append(" AND DATE_FORMAT ( le.modifyTime, '%Y-%m-%d' ) >= :modifyStart ");
            parameters.put(MESS_MODIFY_START, modifyStart);
        }
        if ((modifyEnd = conditions.get(MESS_MODIFY_END)) != null) {
            condition.append(" AND DATE_FORMAT ( le.modifyTime, '%Y-%m-%d' ) <= :modifyEnd ");
            parameters.put(MESS_MODIFY_END, modifyEnd);
        }
        if (StringUtils.isNotBlank((CharSequence)(projectName = (String)conditions.get("projectName")))) {
            condition.append(" AND le.projectName = :projectName");
            parameters.put("projectName", projectName);
        } else {
            condition.append(" AND (le.projectName = '' or le.projectName is null)");
        }
        hql.append((CharSequence)condition).append(" order by le.createTime desc ");
        countHql.append((CharSequence)condition);
        return this.queryByConditions(this.entityManager, hql.toString(), countHql.toString(), parameters, pageable, false, null);
    }

    @Override
    public List<ListTemplateEntity> findAllByConditions(ListTemplateEntity condition) {
        StringBuilder hql = new StringBuilder("select lt from ListTemplateEntity lt where 1=1 ");
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (condition != null && condition.getTstatus() != null) {
            hql.append(" and lt.tstatus = :tstatus");
            parameters.put("tstatus", condition.getTstatus());
        }
        Query query = this.entityManager.createQuery(hql.toString());
        parameters.forEach((k, v) -> query.setParameter(k, v));
        return query.getResultList();
    }
}

