/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service;

import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateGroupEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemEntity;
import com.bizunited.platform.kuiper.entity.TemplateRelationEntity;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.util.CollectionUtils;

public class KuiperToolkitService
extends NebulaToolkitService {
    public Set<String> buildAllWhiteList(TemplateEntity template) {
        Validate.notNull((Object)template, (String)"\u4f20\u5165\u7684\u6a21\u677f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)template.getType(), (CharSequence)"static"), (String)"\u8be5\u670d\u52a1\u53ea\u652f\u6301\u9759\u6001\u6a21\u677f\u63d0\u53d6\u767d\u540d\u5355\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        HashSet<String> whiteList = new HashSet<String>();
        Set relations = template.getRelations();
        this.fetchRelationsWhiteList(relations, whiteList, null);
        Set groups = template.getGroupRelations();
        this.fetchGroupsWhiteList(groups, whiteList, null);
        Set items = template.getItemRelations();
        this.fetchItemsWhiteList(items, whiteList, null);
        return whiteList;
    }

    public Set<String> buildWhiteList(TemplateEntity template) {
        Validate.notNull((Object)template, (String)"\u4f20\u5165\u7684\u6a21\u677f\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)template.getType(), (CharSequence)"static"), (String)"\u8be5\u670d\u52a1\u53ea\u652f\u6301\u9759\u6001\u6a21\u677f\u63d0\u53d6\u767d\u540d\u5355\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        HashSet<String> whiteList = new HashSet<String>();
        Set relations = template.getRelations();
        this.fetchRelationsWhiteList(relations, whiteList, null);
        return whiteList;
    }

    private void fetchGroupsWhiteList(Set<TemplateGroupEntity> groups, Set<String> whiteList, String lastName) {
        if (CollectionUtils.isEmpty(groups)) {
            return;
        }
        for (TemplateGroupEntity group : groups) {
            String currentName = group.getPropertyName();
            String currentWhiteName = this.buildCurrentWhiteName(lastName, currentName);
            whiteList.add(currentWhiteName);
            if (!CollectionUtils.isEmpty((Collection)group.getRelations())) {
                this.fetchRelationsWhiteList(group.getRelations(), whiteList, currentWhiteName);
            }
            if (CollectionUtils.isEmpty((Collection)group.getItemRelations())) continue;
            this.fetchItemsWhiteList(group.getItemRelations(), whiteList, currentWhiteName);
        }
    }

    private void fetchRelationsWhiteList(Set<TemplateRelationEntity> relations, Set<String> whiteList, String lastName) {
        if (CollectionUtils.isEmpty(relations)) {
            return;
        }
        Set needRelations = relations.stream().filter(e -> e.getBackProperty() == false).collect(Collectors.toSet());
        if (CollectionUtils.isEmpty(needRelations)) {
            return;
        }
        for (TemplateRelationEntity relation : needRelations) {
            String currentName = relation.getPropertyName();
            String currentWhiteName = this.buildCurrentWhiteName(lastName, currentName);
            whiteList.add(currentWhiteName);
        }
    }

    private void fetchItemsWhiteList(Set<TemplateItemEntity> items, Set<String> whiteList, String lastName) {
        if (CollectionUtils.isEmpty(items)) {
            return;
        }
        for (TemplateItemEntity item : items) {
            String currentName = item.getPropertyName();
            String currentWhiteName = this.buildCurrentWhiteName(lastName, currentName);
            whiteList.add(currentWhiteName);
            if (CollectionUtils.isEmpty((Collection)item.getRelations())) continue;
            this.fetchRelationsWhiteList(item.getRelations(), whiteList, currentWhiteName);
        }
    }

    private String buildCurrentWhiteName(String lastName, String currentName) {
        return StringUtils.isBlank((CharSequence)lastName) ? currentName : lastName + "." + currentName;
    }
}

