/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.init;

import com.bizunited.platform.common.enums.ImportExecuteModeEnum;
import com.bizunited.platform.common.enums.MigrateDataTypeEnum;
import com.bizunited.platform.common.service.init.InitProcessService;
import com.bizunited.platform.common.util.FileUtils;
import com.bizunited.platform.kuiper.entity.MigrateImportEntity;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.common.enums.FormTemplateImportEnum;
import com.bizunited.platform.kuiper.starter.service.migrate.MigrateImportService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.multipart.MultipartFile;

@Component(value="FormTemplateInitProcess")
public class FormTemplateInitProcess
implements InitProcessService {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormTemplateInitProcess.class);
    private static final String INIT_FILE_PATH = "classpath:".concat("templates/form/");
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private MigrateImportService templateImportService;
    @Autowired
    private TemplateService templateService;

    public boolean doProcess() {
        return true;
    }

    public void init() {
        SecurityUtils.setPrincipal((String)"admin");
        FormTemplateImportEnum[] enums = FormTemplateImportEnum.values();
        if (enums == null) {
            return;
        }
        for (FormTemplateImportEnum e : enums) {
            this.init(e);
        }
    }

    private void init(FormTemplateImportEnum en) {
        if (en == null) {
            return;
        }
        List templateEntities = this.templateService.findByCode(en.getCode());
        if (!CollectionUtils.isEmpty((Collection)templateEntities)) {
            return;
        }
        Resource resource = this.applicationContext.getResource(INIT_FILE_PATH.concat(en.getFileName()));
        try (InputStream inputStream = resource.getInputStream();){
            MultipartFile multipartFile = FileUtils.transferMultipartFile((InputStream)inputStream, (String)en.getFileName());
            MigrateImportEntity migrateImportEntity = this.templateImportService.upload(multipartFile, MigrateDataTypeEnum.FORM_TEMPLATE.getType());
            if (migrateImportEntity == null) {
                return;
            }
            this.templateImportService.execute(migrateImportEntity.getId(), ImportExecuteModeEnum.ADD.getMode());
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }
}

