/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.init;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.enums.ImportExecuteModeEnum;
import com.bizunited.platform.common.enums.MigrateDataTypeEnum;
import com.bizunited.platform.common.service.init.InitProcessService;
import com.bizunited.platform.common.util.FileUtils;
import com.bizunited.platform.kuiper.entity.FromDetailsImportEntity;
import com.bizunited.platform.kuiper.entity.ListTemplateEntity;
import com.bizunited.platform.kuiper.entity.MigrateImportEntity;
import com.bizunited.platform.kuiper.starter.common.enums.ListTemplateImportEnum;
import com.bizunited.platform.kuiper.starter.service.FromDetailsImportService;
import com.bizunited.platform.kuiper.starter.service.ListTemplateService;
import com.bizunited.platform.kuiper.starter.service.migrate.MigrateImportService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class ListTemplateInitProcess
implements InitProcessService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListTemplateInitProcess.class);
    private static final String INIT_FILE_PATH = "classpath:".concat("templates/list/");
    private static final String INIT_EXCEL_PATH = "classpath:".concat("templates/excel/");
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private ListTemplateService listTemplateService;
    @Autowired
    private FromDetailsImportService fromDetailsImportService;
    @Autowired
    private MigrateImportService listImportService;
    @Autowired
    private VenusFileService fileService;

    public boolean doProcess() {
        return true;
    }

    public void init() {
        SecurityUtils.setPrincipal((String)"admin");
        ListTemplateImportEnum[] enums = ListTemplateImportEnum.values();
        if (enums == null) {
            return;
        }
        for (ListTemplateImportEnum en : enums) {
            this.init(en);
        }
    }

    private void init(ListTemplateImportEnum en) {
        Throwable throwable;
        if (en == null) {
            return;
        }
        Set<ListTemplateEntity> oldList = this.listTemplateService.findByCode(en.getCode());
        if (!CollectionUtils.isEmpty(oldList)) {
            return;
        }
        Resource excel = this.applicationContext.getResource(INIT_EXCEL_PATH.concat(en.getExcelName()));
        Resource template = this.applicationContext.getResource(INIT_FILE_PATH.concat(en.getFileName()));
        if (template == null) {
            return;
        }
        String templateCode = null;
        String templateVersion = null;
        ListTemplateEntity listTemplateEntity = null;
        try {
            throwable = null;
            try (InputStream inTemplate = template.getInputStream();){
                if (inTemplate == null) {
                    return;
                }
                MultipartFile multipartFile = FileUtils.transferMultipartFile((InputStream)inTemplate, (String)en.getFileName());
                MigrateImportEntity migrateImportEntity = this.listImportService.upload(multipartFile, MigrateDataTypeEnum.LIST_TEMPLATE.getType());
                if (migrateImportEntity == null) {
                    return;
                }
                this.listImportService.execute(migrateImportEntity.getId(), ImportExecuteModeEnum.ADD.getMode());
                Set<ListTemplateEntity> nList = this.listTemplateService.findByCode(en.getCode());
                if (CollectionUtils.isEmpty(nList)) {
                    return;
                }
                listTemplateEntity = nList.iterator().next();
                templateCode = listTemplateEntity.getCode();
                templateVersion = listTemplateEntity.getCversion();
            }
            catch (Throwable multipartFile) {
                throwable = multipartFile;
                throw multipartFile;
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        if (StringUtils.isBlank((CharSequence)en.getExcelName())) {
            return;
        }
        try {
            throwable = null;
            try (InputStream inExcel = excel.getInputStream();){
                if (StringUtils.isBlank(templateCode) || StringUtils.isBlank(templateVersion)) {
                    return;
                }
                FromDetailsImportEntity fromDetailsImportEntity = this.fromDetailsImportService.importTemplate(FileUtils.readBytes((InputStream)inExcel, (int)10240), templateCode, templateVersion, en.getImportBtnCode(), en.getExcelViewName());
                if (fromDetailsImportEntity == null) {
                    return;
                }
                String relativePath = listTemplateEntity.getRelativePath();
                String fileName = listTemplateEntity.getFileName();
                byte[] bytes = this.fileService.readFileContent(relativePath, fileName);
                JSONObject jsonObject = this.readBytesToJson(bytes);
                this.handleImportExcel(jsonObject, fromDetailsImportEntity);
                byte[] nBytes = this.writeObjectToBytes(jsonObject);
                this.fileService.saveFile(relativePath, listTemplateEntity.getFileName(), listTemplateEntity.getFileName(), nBytes);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void handleImportExcel(JSONObject jsonObject, FromDetailsImportEntity fromDetailsImportEntity) {
        if (jsonObject == null || fromDetailsImportEntity == null || StringUtils.isBlank((CharSequence)fromDetailsImportEntity.getRelativePath()) || StringUtils.isBlank((CharSequence)fromDetailsImportEntity.getFileName())) {
            return;
        }
        System.out.println(jsonObject);
        JSONObject content = jsonObject.getJSONObject("content");
        JSONArray btnOperates = content.getJSONArray("btnOperates");
        JSONObject btnOperate = null;
        for (Object btnOperateObj : btnOperates) {
            JSONObject tmp = (JSONObject)btnOperateObj;
            if (!StringUtils.equals((CharSequence)tmp.getString("code"), (CharSequence)fromDetailsImportEntity.getButtonCode())) continue;
            btnOperate = tmp;
            break;
        }
        Validate.notNull(btnOperate, (String)"\u6ca1\u6709\u83b7\u53d6\u5230\u5bfc\u5165\u6309\u94ae", (Object[])new Object[0]);
        JSONArray events = btnOperate.getJSONArray("events");
        List comment = events.stream().filter(e -> "\u5bfc\u5165".equals(((JSONObject)e).get((Object)"comment"))).collect(Collectors.toList());
        Validate.notEmpty(comment);
        JSONObject commentJson = (JSONObject)comment.get(0);
        JSONObject importTemplate = commentJson.getJSONObject("content").getJSONObject("importTemplate");
        importTemplate.put("url", (Object)"/kuiper/fromDetailsImports/downloadTemplate?relativeLocal=".concat(fromDetailsImportEntity.getRelativePath()).concat("&fileName=").concat(fromDetailsImportEntity.getFileName()));
    }

    private byte[] writeObjectToBytes(Object obj) {
        byte[] bytes;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
             ObjectOutputStream sOut = new ObjectOutputStream(out);){
            sOut.writeObject(obj);
            sOut.flush();
            bytes = out.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new byte[0];
        }
        return bytes;
    }

    private JSONObject readBytesToJson(byte[] bytes) {
        Object layoutObject;
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);
             ObjectInputStream sIn = new ObjectInputStream(in);){
            layoutObject = sIn.readObject();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
        if (layoutObject == null) {
            return null;
        }
        return JSON.parseObject((String)JSON.toJSONString((Object)layoutObject));
    }
}

