/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateEventEntity;
import com.bizunited.platform.kuiper.entity.TemplateLayoutEntity;
import com.bizunited.platform.kuiper.entity.TemplatePropertyEntity;
import com.bizunited.platform.kuiper.entity.TemplateRelationEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityEntity;
import com.bizunited.platform.kuiper.starter.repository.TemplateRepository;
import com.bizunited.platform.kuiper.starter.service.TemplateEventService;
import com.bizunited.platform.kuiper.starter.service.TemplateLayoutService;
import com.bizunited.platform.kuiper.starter.service.TemplateVisibilityService;
import com.bizunited.platform.saturn.model.PersistentProperty;
import com.bizunited.platform.saturn.model.PersistentRelation;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import java.io.IOException;
import java.security.Principal;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractTemplateService {
    @Autowired
    private UserService userService;
    @Autowired
    private TemplateRepository templateRepository;
    @Autowired
    private TemplateLayoutService templateLayoutService;
    @Autowired
    private TemplateEventService templateEventService;
    @Autowired
    private TemplateVisibilityService templateVisibilityService;
    @Autowired
    private PlatformContext platformContext;

    protected void saveTemplate(TemplateEntity template, Principal principal) {
        Date currentTime = new Date();
        template.setCreateTime(currentTime);
        template.setModifyTime(currentTime);
        template.setDefaultVersion(Boolean.valueOf(false));
        template.setDomain(template.getDomain() == null ? "" : template.getDomain());
        template.setProjectName(this.platformContext.getAppName());
        String account = principal.getName();
        UserVo creator = this.userService.findByAccount(account);
        Validate.notNull((Object)creator, (String)"\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u521b\u5efa\u8005\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        template.setCreator(account);
        this.templateRepository.save(template);
        this.templateRepository.flush();
    }

    protected void upgradeTemplateLayout(String templateId, String newTemplateId, TemplateEntity newTemplate) {
        try {
            TemplateLayoutEntity newLayout;
            JSONObject templateLayout = this.templateLayoutService.findDetailsByTemplateId(templateId, 1);
            if (templateLayout != null) {
                newLayout = this.templateLayoutService.save(newTemplateId, 1, templateLayout);
                newTemplate.setTemplateLayout((Object)newLayout);
            }
            if ((templateLayout = this.templateLayoutService.findDetailsByTemplateId(templateId, 2)) != null) {
                newLayout = this.templateLayoutService.save(newTemplateId, 2, templateLayout);
                newTemplate.setMobileTemplateLayout((Object)newLayout);
            }
            if ((templateLayout = this.templateLayoutService.findDetailsByTemplateId(templateId, 3)) != null) {
                newLayout = this.templateLayoutService.save(newTemplateId, 3, templateLayout);
                newTemplate.setPrintTemplateLayout((Object)newLayout);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected void upgradeTemplateEvent(String templateId, String newTemplateId, TemplateEntity newTemplate) {
        List<TemplateEventEntity> templateEvents = this.templateEventService.findByTemplateId(templateId);
        if (templateEvents != null && !templateEvents.isEmpty()) {
            Set<TemplateEventEntity> newTemplateEvents = this.templateEventService.upgrade(newTemplateId, templateEvents);
            newTemplate.setEvent(newTemplateEvents);
        }
    }

    protected void upgradeTemplateVisibility(String templateId, String newTemplateId, TemplateEntity newTemplate) {
        Set<TemplateVisibilityEntity> templateVisibilities = this.templateVisibilityService.findDetailsByTemplateId(templateId);
        if (templateVisibilities != null && !templateVisibilities.isEmpty()) {
            Set<TemplateVisibilityEntity> newTemplateVisibilities = this.templateVisibilityService.upgrade(newTemplateId, templateVisibilities);
            newTemplate.setVisibility(newTemplateVisibilities);
        }
    }

    protected TemplateRelationEntity initTemplateRelationEntity(PersistentRelation persistentRelationItem, String parentClassName) {
        TemplateRelationEntity relationModel = new TemplateRelationEntity();
        relationModel.setCanInsert(persistentRelationItem.getCanInsert());
        relationModel.setCanUpdate(persistentRelationItem.getCanUpdate());
        relationModel.setIndex(persistentRelationItem.getIndex());
        relationModel.setNullable(persistentRelationItem.getNullable());
        relationModel.setPropertyClassName(persistentRelationItem.getPropertyClass());
        String propertyDbName = persistentRelationItem.getPropertyDbName() == null ? "" : persistentRelationItem.getPropertyDbName();
        Validate.isTrue((propertyDbName.length() <= 64 ? 1 : 0) != 0, (String)"\u5982\u586b\u5199\u5b57\u6bb5\u7684\u6570\u636e\u5e93\u5c5e\u6027[%s]\uff0c\u5176\u957f\u5ea6\u5e94\u8be5\u5c0f\u4e8e64\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{propertyDbName});
        relationModel.setPropertyDbName(propertyDbName);
        relationModel.setPropertyDesc(persistentRelationItem.getPropertyDesc());
        String propertyName = persistentRelationItem.getPropertyName();
        Validate.notBlank((CharSequence)propertyName, (String)"\u660e\u7ec6\u9879\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((propertyName.length() <= 64 ? 1 : 0) != 0, (String)"\u5c5e\u6027\u540d[%s]\u7684\u957f\u5ea6\u9700\u8981\u5c0f\u4e8e64\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{propertyName});
        relationModel.setPropertyName(propertyName);
        relationModel.setRelationType(persistentRelationItem.getRelationType().toString());
        relationModel.setBackProperty(Boolean.valueOf(StringUtils.equals((CharSequence)parentClassName, (CharSequence)persistentRelationItem.getPropertyClass())));
        relationModel.setCurrentView(null);
        relationModel.setTargetTableName("");
        return relationModel;
    }

    protected TemplatePropertyEntity initTemplatePropertyEntity(PersistentProperty persistentProperty) {
        TemplatePropertyEntity propertyEntity = new TemplatePropertyEntity();
        propertyEntity.setCanInsert(persistentProperty.getCanInsert());
        propertyEntity.setCanUpdate(persistentProperty.getCanUpdate());
        propertyEntity.setUnique(persistentProperty.getUnique());
        propertyEntity.setIndex(persistentProperty.getIndex());
        propertyEntity.setNullable(persistentProperty.getNullable());
        propertyEntity.setPrimaryKey(persistentProperty.getPrimaryKey());
        propertyEntity.setPropertyClassName(persistentProperty.getPropertyClass());
        String propertyDbName = persistentProperty.getPropertyDbName() == null ? "" : persistentProperty.getPropertyDbName();
        Validate.isTrue((propertyDbName.length() <= 64 ? 1 : 0) != 0, (String)"\u5982\u586b\u5199\u5b57\u6bb5\u7684\u6570\u636e\u5e93\u5c5e\u6027[%s]\uff0c\u5176\u957f\u5ea6\u5e94\u8be5\u5c0f\u4e8e64\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{propertyDbName});
        propertyEntity.setPropertyDbName(propertyDbName);
        propertyEntity.setPropertyDesc(persistentProperty.getPropertyDesc());
        String propertyName = persistentProperty.getPropertyName();
        Validate.notBlank((CharSequence)propertyName, (String)"\u660e\u7ec6\u9879\u5c5e\u6027\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((propertyName.length() <= 64 ? 1 : 0) != 0, (String)"\u5c5e\u6027\u540d[%s]\u7684\u957f\u5ea6\u9700\u8981\u5c0f\u4e8e64\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{propertyName});
        propertyEntity.setPropertyName(propertyName);
        propertyEntity.setDefaultKeys(persistentProperty.getDefaultKeys());
        propertyEntity.setDefaultValues(persistentProperty.getDefaultValues());
        propertyEntity.setDefaultController(persistentProperty.getDefaultType() != null ? persistentProperty.getDefaultType() : "");
        propertyEntity.setMaxLen(persistentProperty.getMaxLen());
        return propertyEntity;
    }
}

