/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.enums.ImportExecuteModeEnum;
import com.bizunited.platform.common.model.MigrateImportModel;
import com.bizunited.platform.common.util.ZipFileUtils;
import com.bizunited.platform.kuiper.entity.ListTemplateEntity;
import com.bizunited.platform.kuiper.starter.repository.ListTemplateRepository;
import com.bizunited.platform.kuiper.starter.service.KuiperToolkitService;
import com.bizunited.platform.kuiper.starter.service.ListTemplateService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.security.Principal;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="ListTemplateEntityServiceImpl")
public class ListTemplateServiceImpl
implements ListTemplateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListTemplateServiceImpl.class);
    @Autowired
    private VenusFileService venusFileService;
    @Autowired
    private UserService userService;
    @Autowired
    @Qualifier(value="KuiperToolkitService")
    private KuiperToolkitService kuiperToolkitService;
    @Autowired
    private ListTemplateRepository listTemplateEntityRepository;
    @Autowired
    private PlatformContext platformContext;
    private static final String LAYOUTDIR = "/listTemplate/layout";
    private static final String EXTENDTYPE = ".txt";

    @Override
    @Transactional
    public ListTemplateEntity init(ListTemplateEntity listTemplateEntity, Principal principal) {
        String userName = principal.getName();
        Validate.notBlank((CharSequence)userName, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u7528\u6237\u540d\u4fe1\u606f", (Object[])new Object[0]);
        UserVo creator = this.userService.findByAccount(userName);
        Validate.notNull((Object)creator, (String)"\u9519\u8bef\u7684\u521b\u5efa\u4eba\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        listTemplateEntity.setCreator(userName);
        listTemplateEntity.setProjectName(this.platformContext.getAppName());
        return this.initForm(listTemplateEntity);
    }

    private ListTemplateEntity initForm(ListTemplateEntity listTemplateEntity) {
        this.createValidation(listTemplateEntity);
        Long countByCode = this.listTemplateEntityRepository.countByCode(listTemplateEntity.getCode());
        listTemplateEntity.setDefaultVersion(Boolean.valueOf(null == countByCode || countByCode == 0L));
        listTemplateEntity.setModifyTime(new Date());
        listTemplateEntity.setProjectName(this.platformContext.getAppName());
        this.listTemplateEntityRepository.saveAndFlush(listTemplateEntity);
        return listTemplateEntity;
    }

    private void createValidation(ListTemplateEntity listTemplate) {
        Validate.notNull((Object)listTemplate, (String)"\u8fdb\u884c\u5f53\u524d\u64cd\u4f5c\u65f6\uff0c\u4fe1\u606f\u5bf9\u8c61\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)listTemplate.getId()), (String)"\u6dfb\u52a0\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u4e0d\u80fd\u6709\u503c\uff01", (Object[])new Object[0]);
        listTemplate.setId(null);
        Validate.notBlank((CharSequence)listTemplate.getCode(), (String)"\u5217\u8868\u6a21\u677f\u7684\u552f\u4e00\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)listTemplate.getCversion(), (String)"\u5217\u8868\u6a21\u677f\u7248\u672c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)listTemplate.getName(), (String)"\u5217\u8868\u6a21\u677f\u7684\u4e2d\u6587\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        listTemplate.setTstatus(Integer.valueOf(1));
        if (listTemplate.getDataSource() == null) {
            listTemplate.setDataSource(Integer.valueOf(2));
        }
        listTemplate.setCreateTime(new Date());
        Set<ListTemplateEntity> exsitCode = this.listTemplateEntityRepository.findByCode(listTemplate.getCode());
        Validate.isTrue((boolean)CollectionUtils.isEmpty(exsitCode), (String)"\u5f53\u524d\u6307\u5b9a\u7f16\u53f7\u3010%s\u3011\u5df2\u5b58\u5728", (Object[])new Object[]{listTemplate.getCode()});
        ListTemplateEntity exsit = this.listTemplateEntityRepository.findByCodeAndCversion(listTemplate.getCode(), listTemplate.getCversion());
        Validate.isTrue((exsit == null ? 1 : 0) != 0, (String)"\u5f53\u524d\u6307\u5b9a\u7f16\u53f7\u3010%s\u3011\uff0c\u6307\u5b9a\u7248\u672c\u4e0b\u3010%s\u3011\u7684\u5217\u8868\u6a21\u677f\u4fe1\u606f\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{listTemplate.getCode(), listTemplate.getCversion()});
        Validate.isTrue((listTemplate.getCode() == null || listTemplate.getCode().length() < 128 ? 1 : 0) != 0, (String)"\u5217\u8868\u6a21\u677f\u7684\u552f\u4e00\u7f16\u53f7,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((listTemplate.getProjectName() == null || listTemplate.getProjectName().length() < 128 ? 1 : 0) != 0, (String)"\u9879\u76ee\u540d,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((listTemplate.getCversion() == null || listTemplate.getCversion().length() < 64 ? 1 : 0) != 0, (String)"\u4e0d\u540c\u7684\u7248\u672c\u4fe1\u606f,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((listTemplate.getName() == null || listTemplate.getName().length() < 128 ? 1 : 0) != 0, (String)"\u5217\u8868\u6a21\u677f\u7684\u4e2d\u6587\u8bf4\u660e,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((listTemplate.getRelativePath() == null || listTemplate.getRelativePath().length() < 256 ? 1 : 0) != 0, (String)"\u5217\u8868\u6a21\u677f\u6587\u4ef6\u7684\u76f8\u5bf9\u76ee\u5f55,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((listTemplate.getFileName() == null || listTemplate.getFileName().length() < 256 ? 1 : 0) != 0, (String)"\u4fdd\u5b58\u7684\u5217\u8868\u6a21\u677f\u5e03\u5c40\u6587\u4ef6\u6587\u4ef6\u540d,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(256)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    @Override
    @Transactional
    public ListTemplateEntity update(ListTemplateEntity listTemplateEntity) {
        return this.updateForm(listTemplateEntity);
    }

    private ListTemplateEntity updateForm(ListTemplateEntity listTemplateEntity) {
        this.updateValidation(listTemplateEntity);
        String currentId = listTemplateEntity.getId();
        Optional op = this.listTemplateEntityRepository.findById(currentId);
        ListTemplateEntity currentListTemplateEntity = op.orElse(null);
        Validate.notNull((Object)currentListTemplateEntity, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u539f\u59cb\u6a21\u578b\u5bf9\u8c61\u4fe1", (Object[])new Object[0]);
        currentListTemplateEntity.setCode(listTemplateEntity.getCode());
        currentListTemplateEntity.setProjectName(this.platformContext.getAppName());
        currentListTemplateEntity.setCversion(listTemplateEntity.getCversion());
        currentListTemplateEntity.setName(listTemplateEntity.getName());
        currentListTemplateEntity.setTstatus(listTemplateEntity.getTstatus());
        currentListTemplateEntity.setDataSource(listTemplateEntity.getDataSource());
        currentListTemplateEntity.setRelativePath(listTemplateEntity.getRelativePath());
        currentListTemplateEntity.setFileName(listTemplateEntity.getFileName());
        currentListTemplateEntity.setModifyTime(new Date());
        this.listTemplateEntityRepository.saveAndFlush(currentListTemplateEntity);
        return currentListTemplateEntity;
    }

    private void updateValidation(ListTemplateEntity listTemplateEntity) {
        Validate.isTrue((!StringUtils.isBlank((CharSequence)listTemplateEntity.getId()) ? 1 : 0) != 0, (String)"\u4fee\u6539\u4fe1\u606f\u65f6\uff0c\u5f53\u671f\u4fe1\u606f\u7684\u6570\u636e\u7f16\u53f7\uff08\u4e3b\u952e\uff09\u5fc5\u987b\u6709\u503c\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)listTemplateEntity.getCode(), (String)"\u5217\u8868\u6a21\u677f\u7684\u552f\u4e00\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)listTemplateEntity.getCversion(), (String)"\u4e0d\u540c\u7684\u7248\u672c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)listTemplateEntity.getName(), (String)"\u5217\u8868\u6a21\u677f\u7684\u4e2d\u6587\u8bf4\u660e\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)listTemplateEntity.getTstatus(), (String)"\u5217\u8868\u6a21\u677f\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)listTemplateEntity.getDataSource(), (String)"\u6570\u636e\u6e90\u7c7b\u578b\uff1a1\u3001\u670d\u52a1\u6e90\uff1b2\u3001\u6570\u636e\u89c6\u56fe\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.isTrue((listTemplateEntity.getCode() == null || listTemplateEntity.getCode().length() < 128 ? 1 : 0) != 0, (String)"\u5217\u8868\u6a21\u677f\u7684\u552f\u4e00\u7f16\u53f7,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((listTemplateEntity.getProjectName() == null || listTemplateEntity.getProjectName().length() < 128 ? 1 : 0) != 0, (String)"\u9879\u76ee\u540d,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((listTemplateEntity.getCversion() == null || listTemplateEntity.getCversion().length() < 64 ? 1 : 0) != 0, (String)"\u4e0d\u540c\u7684\u7248\u672c\u4fe1\u606f,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(64)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        Validate.isTrue((listTemplateEntity.getName() == null || listTemplateEntity.getName().length() < 128 ? 1 : 0) != 0, (String)"\u5217\u8868\u6a21\u677f\u7684\u4e2d\u6587\u8bf4\u660e,\u586b\u5165\u503c\u8d85\u8fc7\u4e86\u9650\u5b9a\u957f\u5ea6(128)\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
    }

    private byte[] writeObjectToBytes(Object obj) {
        byte[] bytes;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();
             ObjectOutputStream sOut = new ObjectOutputStream(out);){
            sOut.writeObject(obj);
            sOut.flush();
            bytes = out.toByteArray();
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return new byte[0];
        }
        return bytes;
    }

    private JSONObject readBytesToJson(byte[] bytes) {
        Object layoutObject;
        try (ByteArrayInputStream in = new ByteArrayInputStream(bytes);
             ObjectInputStream sIn = new ObjectInputStream(in);){
            layoutObject = sIn.readObject();
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
        if (layoutObject == null) {
            return null;
        }
        return JSON.parseObject((String)JSON.toJSONString((Object)layoutObject));
    }

    @Override
    @Transactional
    public ListTemplateEntity updateContentById(String id, JSONObject content) {
        Validate.notBlank((CharSequence)id, (String)"\u66f4\u65b0\u5217\u8868\u6a21\u677f\u5185\u5bb9\u65f6\uff0c\u5217\u8868\u6a21\u677f\u7f16\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notNull((Object)content, (String)"\u66f4\u65b0\u5217\u8868\u6a21\u677f\u5185\u5bb9\u65f6\uff0cJSON\u7ed3\u6784\u7684\u5185\u5bb9\u672c\u8eab\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        String relativePath = LAYOUTDIR;
        String fileName = StringUtils.join((Object[])new String[]{id, EXTENDTYPE});
        byte[] objectContents = this.writeObjectToBytes(content);
        this.venusFileService.saveFile(relativePath, fileName, fileName, objectContents);
        Optional op = this.listTemplateEntityRepository.findById(id);
        ListTemplateEntity listTemplate = op.orElse(null);
        Validate.notNull((Object)listTemplate, (String)"\u9519\u8bef\u7684\u5217\u8868\u6a21\u677f\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[0]);
        listTemplate.setFileName(fileName);
        listTemplate.setRelativePath(relativePath);
        listTemplate.setModifyTime(new Date());
        this.listTemplateEntityRepository.saveAndFlush(listTemplate);
        return listTemplate;
    }

    @Override
    public JSONObject findContentById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.listTemplateEntityRepository.findById(id);
        Validate.isTrue((boolean)op.isPresent(), (String)"\u9519\u8bef\u7684\u5217\u8868\u6a21\u677f\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[0]);
        String relativePath = LAYOUTDIR;
        String fileName = StringUtils.join((Object[])new String[]{id, EXTENDTYPE});
        byte[] contentBytes = this.venusFileService.readFileContent(relativePath, fileName);
        Validate.notNull((Object)contentBytes, (String)"\u672a\u8bfb\u53d6\u5230\u6307\u5b9a\u5217\u8868\u6a21\u677f\u7684\u5e03\u5c40\u63cf\u8ff0\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5!", (Object[])new Object[]{id});
        return this.readBytesToJson(contentBytes);
    }

    @Override
    public ListTemplateEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return this.listTemplateEntityRepository.findDetailsById(id);
    }

    @Override
    public Set<ListTemplateEntity> findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return Sets.newHashSet();
        }
        return this.listTemplateEntityRepository.findByCode(code);
    }

    @Override
    public ListTemplateEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.listTemplateEntityRepository.findById(id);
        return op.orElse(null);
    }

    @Override
    public Page<ListTemplateEntity> findByConditions(Pageable pageable, Map<String, Object> conditions) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        if (conditions == null) {
            conditions = new HashMap<String, Object>();
        }
        conditions.put("projectName", this.platformContext.getAppName());
        return this.listTemplateEntityRepository.findByConditions(pageable, conditions);
    }

    @Override
    public int countByIds(String[] ids) {
        if (ids == null || ids.length == 0) {
            return 0;
        }
        return this.listTemplateEntityRepository.countByIds(ids);
    }

    @Override
    @Transactional
    public void deleteById(String id) {
        Validate.notBlank((CharSequence)id, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u5fc5\u987b\u7ed9\u5b9a\u4e3b\u952e\u4fe1\u606f!!", (Object[])new Object[0]);
        Optional op = this.listTemplateEntityRepository.findById(id);
        op.ifPresent(listTemplateEntity -> this.listTemplateEntityRepository.delete(listTemplateEntity));
    }

    @Override
    public JSONObject findContentByCodeAndCversion(String code, String cversion) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{code, cversion})) {
            return null;
        }
        ListTemplateEntity templateEntity = this.listTemplateEntityRepository.findDetailsByCodeAndCversion(code, cversion);
        Validate.notNull((Object)templateEntity, (String)"\u9519\u8bef\u7684\u5217\u8868\u6a21\u677f\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String relativePath = LAYOUTDIR;
        String fileName = StringUtils.join((Object[])new String[]{templateEntity.getId(), EXTENDTYPE});
        byte[] contentBytes = this.venusFileService.readFileContent(relativePath, fileName);
        Validate.notNull((Object)contentBytes, (String)"\u672a\u8bfb\u53d6\u5230\u6307\u5b9a\u5217\u8868\u6a21\u677f\u7684\u5e03\u5c40\u63cf\u8ff0\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{code});
        return this.readBytesToJson(contentBytes);
    }

    @Override
    public ListTemplateEntity findByCodeAndCversion(String code, String cversion) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{code, cversion})) {
            return null;
        }
        return this.listTemplateEntityRepository.findDetailsByCodeAndCversion(code, cversion);
    }

    @Override
    @Transactional
    public ListTemplateEntity updateContentByCodeAndCversion(String code, String cversion, JSONObject content) {
        Validate.notBlank((CharSequence)code, (String)"\u66f4\u65b0\u5217\u8868\u6a21\u677f\u5185\u5bb9\u65f6\uff0c\u5217\u8868\u6a21\u677f\u7f16\u7801\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)cversion, (String)"\u66f4\u65b0\u5217\u8868\u6a21\u677f\u5185\u5bb9\u65f6\uff0c\u5217\u8868\u6a21\u677f\u7248\u672c\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notNull((Object)content, (String)"\u66f4\u65b0\u5217\u8868\u6a21\u677f\u5185\u5bb9\u65f6\uff0cJSON\u7ed3\u6784\u7684\u5185\u5bb9\u672c\u8eab\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        ListTemplateEntity templateEntity = this.listTemplateEntityRepository.findDetailsByCodeAndCversion(code, cversion);
        Validate.notNull((Object)templateEntity, (String)"\u9519\u8bef\u7684\u5217\u8868\u6a21\u677f\u7f16\u53f7\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String relativePath = LAYOUTDIR;
        String fileName = StringUtils.join((Object[])new String[]{templateEntity.getId(), EXTENDTYPE});
        byte[] objectContents = this.writeObjectToBytes(content);
        this.venusFileService.saveFile(relativePath, fileName, fileName, objectContents);
        templateEntity.setFileName(fileName);
        templateEntity.setRelativePath(relativePath);
        this.listTemplateEntityRepository.saveAndFlush(templateEntity);
        return templateEntity;
    }

    @Override
    public JSONObject findDefaultContentByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        ListTemplateEntity templateEntity = this.listTemplateEntityRepository.findDefaultByCode(code);
        Validate.notNull((Object)templateEntity, (String)"\u6ca1\u6709\u627e\u5230\u5f53\u524d\u5217\u8868\u6a21\u677f\u7684\u9ed8\u8ba4\u7248\u672c\uff0c\u8bf7\u8bbe\u7f6e\u9ed8\u8ba4\u7248\u672c!!", (Object[])new Object[0]);
        String relativePath = LAYOUTDIR;
        String fileName = StringUtils.join((Object[])new String[]{templateEntity.getId(), EXTENDTYPE});
        byte[] contentBytes = this.venusFileService.readFileContent(relativePath, fileName);
        Validate.notNull((Object)contentBytes, (String)"\u672a\u8bfb\u53d6\u5230\u6307\u5b9a\u5217\u8868\u6a21\u677f\u7684\u5e03\u5c40\u63cf\u8ff0\u4fe1\u606f[%s]\uff0c\u8bf7\u68c0\u67e5", (Object[])new Object[]{code});
        return this.readBytesToJson(contentBytes);
    }

    @Override
    @Transactional
    public void updateDefaultVersion(String code, String cversion) {
        Validate.notBlank((CharSequence)code, (String)"\u66f4\u65b0\u5217\u8868\u6a21\u677f\u5185\u5bb9\u65f6\uff0c\u5217\u8868\u6a21\u677f\u7f16\u7801\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)cversion, (String)"\u66f4\u65b0\u5217\u8868\u6a21\u677f\u5185\u5bb9\u65f6\uff0c\u5217\u8868\u6a21\u677f\u7248\u672c\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        ListTemplateEntity detailsByCode = this.listTemplateEntityRepository.findDetailsByCodeAndCversion(code, cversion);
        Validate.notNull((Object)detailsByCode, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u5217\u8868\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((detailsByCode.getTstatus() == 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u6307\u5b9a\u6a21\u677f\u7684\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\uff08\u6a21\u677f\u72b6\u6001\u4e0d\u80fd\u4e3a\u7981\u7528\uff09!", (Object[])new Object[0]);
        this.listTemplateEntityRepository.updateDefaultVersion(code, Boolean.FALSE);
        this.listTemplateEntityRepository.updateDefaultVersion(code, cversion, Boolean.TRUE, new Date());
    }

    @Override
    public ListTemplateEntity findDefaultByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.listTemplateEntityRepository.findDefaultByCode(code);
    }

    @Override
    public List<ListTemplateEntity> findAllByConditions(ListTemplateEntity condition) {
        return this.listTemplateEntityRepository.findAllByConditions(condition);
    }

    @Override
    public List<ListTemplateEntity> findByIds(String[] ids) {
        if (ArrayUtils.isEmpty((Object[])ids)) {
            return Lists.newArrayList();
        }
        return this.listTemplateEntityRepository.findByIds(ids);
    }

    @Override
    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void importData(MigrateImportModel importModel) {
        Validate.notNull((Object)importModel, (String)"\u5bfc\u5165\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ZipFile zipFile = importModel.getZipFile();
        Validate.notNull((Object)zipFile, (String)"\u5bfc\u5165\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)importModel.getExecuteMode(), (String)"\u6267\u884c\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        importModel.appendLine("\u5f00\u59cb\u5bfc\u5165\u6570\u636e");
        ZipEntry templateEntry = zipFile.getEntry("listTemplate.in");
        if (templateEntry == null) {
            importModel.appendLine("\u5bfc\u5165\u538b\u7f29\u5305\u4e2d\u672a\u53d1\u73b0\u6570\u636e\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5");
            return;
        }
        try (InputStream is = zipFile.getInputStream(templateEntry);
             ObjectInputStream ois = new ObjectInputStream(is);){
            List templates = (List)ois.readObject();
            if (CollectionUtils.isEmpty((Collection)templates)) {
                importModel.appendLine("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
                return;
            }
            this.importData(templates, importModel);
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            importModel.append("\u8bfb\u53d6\u6a21\u7248\u6570\u636e\u5931\u8d25\uff1a").appendLine(e.getMessage());
        }
    }

    private void importData(List<ListTemplateEntity> templates, MigrateImportModel importModel) {
        importModel.setTotalCount(templates.size());
        for (int i = 0; i < templates.size(); ++i) {
            ListTemplateEntity template = templates.get(i);
            importModel.appendLine(StringUtils.join((Object[])new Serializable[]{"--------[", Integer.valueOf(i + 1), "]----------"}));
            this.importData(template, importModel);
        }
    }

    private void importData(ListTemplateEntity template, MigrateImportModel importModel) {
        importModel.appendLine(String.format("\u5f00\u59cb\u5bfc\u5165\u6570\u636e\uff1a\u7f16\u53f7=%s,\u7248\u672c\u53f7=%s", template.getCode(), template.getCversion()));
        ImportExecuteModeEnum executeMode = importModel.getExecuteMode();
        ListTemplateEntity dbTemplate = this.listTemplateEntityRepository.findByCodeAndCversion(template.getCode(), template.getCversion());
        template.setId(null);
        if (dbTemplate != null && ImportExecuteModeEnum.SKIP == executeMode) {
            importModel.appendLine("\u6a21\u7248\u6570\u636e\u5df2\u5b58\u5728\uff0c\u6267\u884c\u8df3\u8fc7");
            importModel.addSkipCount();
            return;
        }
        if (dbTemplate != null && ImportExecuteModeEnum.UPDATE == executeMode) {
            importModel.appendLine("\u6a21\u7248\u6570\u636e\u5df2\u5b58\u5728\uff0c\u6267\u884c\u66f4\u65b0\u5bfc\u5165");
            this.handleUpdateData(template, dbTemplate, importModel);
            return;
        }
        if (dbTemplate != null && ImportExecuteModeEnum.ADD == executeMode) {
            this.handleCreateDataOnExist(template, importModel);
            return;
        }
        if (dbTemplate == null) {
            this.handleCreateData(template, importModel);
            return;
        }
    }

    private ListTemplateEntity handleCreateDataOnExist(ListTemplateEntity template, MigrateImportModel importModel) {
        String newVersion;
        long versionCount;
        importModel.appendLine("\u6a21\u7248\u6570\u636e\u5df2\u5b58\u5728\uff0c\u6267\u884c\u7248\u672c\u5347\u7ea7\u5bfc\u5165");
        int count = 1;
        do {
            newVersion = StringUtils.join((Object[])new Serializable[]{template.getCversion(), "_", Integer.valueOf(count)});
            ++count;
        } while ((versionCount = this.listTemplateEntityRepository.countByCodeAndVersion(template.getCode(), newVersion)) > 0L);
        importModel.append("\u751f\u6210\u65b0\u7684\u7248\u672c\u53f7\uff1a").appendLine(newVersion);
        importModel.appendLine("\u5bfc\u5165\u6a21\u7248\u6570\u636e");
        template.setCversion(newVersion);
        return this.handleCreateData(template, importModel);
    }

    private ListTemplateEntity handleCreateData(ListTemplateEntity template, MigrateImportModel importModel) {
        importModel.appendLine("\u5bfc\u5165\u65b0\u589e\u6a21\u7248\u6570\u636e\uff1a\u7f16\u53f7=%s\uff0c\u7248\u672c=%s", new Object[]{template.getCode(), template.getCversion()});
        template.setDefaultVersion(Boolean.valueOf(false));
        Principal principal = SecurityUtils.getPrincipal();
        ListTemplateEntity dbTemplate = this.init(template, principal);
        this.importTemplateFile(template, dbTemplate, importModel);
        importModel.appendLine("\u5bfc\u5165\u65b0\u589e\u6a21\u7248\u6210\u529f");
        importModel.addCreateCount();
        return dbTemplate;
    }

    private ListTemplateEntity handleUpdateData(ListTemplateEntity template, ListTemplateEntity dbTemplate, MigrateImportModel importModel) {
        template.setId(dbTemplate.getId());
        dbTemplate = this.update(template);
        this.importTemplateFile(template, dbTemplate, importModel);
        importModel.appendLine("\u66f4\u65b0\u6a21\u7248\u6210\u529f");
        importModel.addUpdateCount();
        return dbTemplate;
    }

    private void importTemplateFile(ListTemplateEntity template, ListTemplateEntity dbTemplate, MigrateImportModel importModel) {
        try {
            importModel.appendLine("\u83b7\u53d6\u6a21\u7248\u6587\u4ef6\u6570\u636e");
            byte[] bytes = ZipFileUtils.readZipFile((ZipFile)importModel.getZipFile(), (String)template.getRelativePath(), (String)template.getFileName());
            Validate.isTrue((boolean)ArrayUtils.isNotEmpty((byte[])bytes), (String)"\u6a21\u7248\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e", (Object[])new Object[0]);
            JSONObject json = this.readBytesToJson(bytes);
            importModel.appendLine("\u5bfc\u5165\u6a21\u7248\u6587\u4ef6\u6570\u636e");
            this.updateContentById(dbTemplate.getId(), json);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException("\u8bfb\u53d6\u6a21\u7248\u6587\u4ef6\u5931\u8d25", e);
        }
    }
}

