/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.kuiper.entity.PageEntity;
import com.bizunited.platform.kuiper.entity.PageEventEntity;
import com.bizunited.platform.kuiper.entity.PageFlowEntity;
import com.bizunited.platform.kuiper.starter.repository.PageRepository;
import com.bizunited.platform.kuiper.starter.service.KuiperToolkitService;
import com.bizunited.platform.kuiper.starter.service.PageEventService;
import com.bizunited.platform.kuiper.starter.service.PageService;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="PageServiceImpl")
public class PageServiceImpl
implements PageService {
    private static final String JSON_FILE_SUFFIX = "json";
    private static final String SAVE_LOCATION = "/page/json/";
    @Autowired
    private PageRepository pageRepository;
    @Autowired
    private PageEventService pageEventService;
    @Autowired
    private VenusFileService kuiperFileService;
    @Autowired
    private KuiperToolkitService kuiperToolkitService;
    @Autowired
    private PlatformContext platformContext;

    @Override
    @Transactional
    public Set<PageEntity> save(PageFlowEntity pageFlow, Set<PageEntity> pages) {
        this.saveValidation(pageFlow, pages);
        Set<PageEntity> oldPages = this.pageRepository.findDetailsByPageFlowId(pageFlow.getId());
        if (CollectionUtils.isEmpty(pages)) {
            this.delete(oldPages);
            return Sets.newHashSet();
        }
        HashSet<PageEntity> needInsertPages = new HashSet<PageEntity>();
        HashSet<PageEntity> needUpdatePages = new HashSet<PageEntity>();
        HashSet<PageEntity> needDeletePages = new HashSet<PageEntity>();
        this.kuiperToolkitService.collectionDiscrepancy(pages, oldPages, PageEntity::getCode, needDeletePages, needUpdatePages, needInsertPages);
        this.create(pageFlow, needInsertPages);
        this.update(pages, needUpdatePages);
        this.delete(needDeletePages);
        needInsertPages.addAll(needUpdatePages);
        return needInsertPages;
    }

    private void delete(Set<PageEntity> pages) {
        if (CollectionUtils.isEmpty(pages)) {
            return;
        }
        for (PageEntity page : pages) {
            this.pageEventService.deleteByPageId(page.getId());
            this.kuiperFileService.deleteFile(page.getRelativePath(), page.getFileName(), page.getFileName());
        }
        this.pageRepository.deleteAll(pages);
    }

    private void create(PageFlowEntity pageFlow, Set<PageEntity> needInsertPages) {
        needInsertPages.forEach(page -> {
            page.setPageFlow(pageFlow);
            this.saveFile((PageEntity)page);
            page.setProjectName(this.platformContext.getAppName());
            this.pageRepository.save(page);
            this.pageEventService.save((PageEntity)page, page.getEvents());
        });
    }

    private void update(Set<PageEntity> pages, Set<PageEntity> needUpdatePages) {
        Map<String, PageEntity> newUpdatePageMap = pages.stream().collect(Collectors.toMap(PageEntity::getCode, e -> e));
        if (CollectionUtils.isEmpty(newUpdatePageMap)) {
            return;
        }
        needUpdatePages.forEach(page -> {
            this.loadDetails((PageEntity)page);
            PageEntity updatePage = (PageEntity)newUpdatePageMap.get(page.getCode());
            if (!page.getPageContent().equals(updatePage.getPageContent())) {
                page.setPageContent(updatePage.getPageContent());
                byte[] pageContent = updatePage.getPageContent().getBytes(StandardCharsets.UTF_8);
                String fileName = page.getFileName();
                this.kuiperFileService.saveFile(page.getRelativePath(), fileName, fileName, pageContent);
            }
            page.setName(updatePage.getName());
            this.pageRepository.save(page);
            this.pageEventService.save((PageEntity)page, updatePage.getEvents());
        });
    }

    private void saveFile(PageEntity page) {
        String folderName = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String renameImage = UUID.randomUUID().toString();
        String fileRename = renameImage + "." + JSON_FILE_SUFFIX;
        String relativePath = StringUtils.join((Object[])new Serializable[]{SAVE_LOCATION, folderName, "/", Integer.valueOf(new Random().nextInt(100) % 10)});
        page.setFileName(fileRename);
        page.setRelativePath(relativePath);
        byte[] pageContent = page.getPageContent().getBytes(StandardCharsets.UTF_8);
        this.kuiperFileService.saveFile(relativePath, fileRename, fileRename, pageContent);
    }

    @Override
    public PageEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        PageEntity page = this.pageRepository.findDetailsById(id);
        return this.loadDetails(page);
    }

    @Override
    public PageEntity findDetailsByCodeAndPageFlowCode(String code, String pageFlowCode) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{code, pageFlowCode})) {
            return null;
        }
        PageEntity page = this.pageRepository.findDetailsByCodeAndPageFlowCode(code, pageFlowCode);
        return this.loadDetails(page);
    }

    @Override
    public Set<PageEntity> findDetailsByPageFlowCode(String pageFlowCode) {
        if (StringUtils.isBlank((CharSequence)pageFlowCode)) {
            return Sets.newHashSet();
        }
        Set<PageEntity> pages = this.pageRepository.findDetailsByPageFlowCode(pageFlowCode);
        if (!CollectionUtils.isEmpty(pages)) {
            pages.forEach(page -> this.loadDetails((PageEntity)page));
        }
        return pages;
    }

    @Override
    public Set<PageEntity> findDetailsByPageFlowId(String pageFlowId) {
        if (StringUtils.isBlank((CharSequence)pageFlowId)) {
            return Sets.newHashSet();
        }
        Set<PageEntity> pages = this.pageRepository.findDetailsByPageFlowId(pageFlowId);
        if (!CollectionUtils.isEmpty(pages)) {
            pages.forEach(page -> this.loadDetails((PageEntity)page));
        }
        return pages;
    }

    @Override
    public Set<PageEntity> findByPageFlowCode(String pageFlowCode) {
        if (StringUtils.isBlank((CharSequence)pageFlowCode)) {
            return Sets.newHashSet();
        }
        return this.pageRepository.findByPageFlowCode(pageFlowCode);
    }

    @Override
    @Transactional
    public void deleteByPageFlowId(String pageFlowId) {
        Validate.notBlank((CharSequence)pageFlowId, (String)"\u9875\u9762\u6d41ID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Set<PageEntity> pages = this.pageRepository.findDetailsByPageFlowId(pageFlowId);
        if (!CollectionUtils.isEmpty(pages)) {
            pages.forEach(page -> {
                this.kuiperFileService.deleteFile(page.getRelativePath(), page.getFileName(), page.getFileName());
                this.pageEventService.deleteByPageId(page.getId());
            });
            this.pageRepository.deleteByPageFlowId(pageFlowId);
        }
    }

    private PageEntity loadDetails(PageEntity page) {
        if (page == null) {
            return null;
        }
        Set<PageEventEntity> pageEvents = this.pageEventService.findDetailsByPageId(page.getId());
        page.setEvents(pageEvents);
        byte[] bytes = this.kuiperFileService.readFileContent(page.getRelativePath(), page.getFileName());
        if (null != bytes) {
            String content = new String(bytes, StandardCharsets.UTF_8);
            page.setPageContent(content);
        }
        return page;
    }

    private void saveValidation(PageFlowEntity pageFlow, Set<PageEntity> pages) {
        Validate.notNull((Object)pageFlow, (String)"\u9875\u9762\u6d41\u5bf9\u8c61\u4e0d\u5b58\u5728!", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)pageFlow.getId(), (String)"\u9875\u9762\u6d41\u5bf9\u8c61ID\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
        if (CollectionUtils.isEmpty(pages)) {
            return;
        }
        HashSet pageCodes = new HashSet();
        pages.forEach(pageEntity -> {
            Validate.notBlank((CharSequence)pageEntity.getName(), (String)"\u9875\u9762\u6d41\u9875\u9762\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)pageEntity.getCode(), (String)"\u9875\u9762\u6d41\u9875\u9762\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.notBlank((CharSequence)pageEntity.getPageContent(), (String)"\u4fdd\u5b58\u7684\u9875\u9762\u6d41\u9875\u9762\u6587\u4ef6\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a!", (Object[])new Object[0]);
            Validate.isTrue((!pageCodes.contains(pageEntity.getCode()) ? 1 : 0) != 0, (String)"\u9875\u9762\u6d41\u9875\u9762\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u66ff\u6362!", (Object[])new Object[0]);
            pageCodes.add(pageEntity.getCode());
        });
    }
}

