/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.core.service.NebulaStaticPersistentService;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateGroupEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemEntity;
import com.bizunited.platform.kuiper.entity.TemplateMaintainerEntity;
import com.bizunited.platform.kuiper.entity.TemplatePropertyEntity;
import com.bizunited.platform.kuiper.entity.TemplateRelationEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityEntity;
import com.bizunited.platform.kuiper.service.InstanceService;
import com.bizunited.platform.kuiper.service.StaticTemplateService;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.common.enums.FormTemplateTypeEnum;
import com.bizunited.platform.kuiper.starter.model.StaticTemplateMergeModel;
import com.bizunited.platform.kuiper.starter.repository.InstanceRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplatePropertyRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplateRelationRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplateRepository;
import com.bizunited.platform.kuiper.starter.service.StaticTemplateMergeService;
import com.bizunited.platform.kuiper.starter.service.TemplateEventService;
import com.bizunited.platform.kuiper.starter.service.TemplateGroupService;
import com.bizunited.platform.kuiper.starter.service.TemplateItemService;
import com.bizunited.platform.kuiper.starter.service.TemplateMaintainerService;
import com.bizunited.platform.kuiper.starter.service.TemplateVisibilityService;
import com.bizunited.platform.kuiper.starter.service.internal.AbstractTemplateService;
import com.bizunited.platform.saturn.model.PersistentClass;
import com.bizunited.platform.saturn.model.PersistentProperty;
import com.bizunited.platform.saturn.model.PersistentRelation;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import java.security.Principal;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="StaticTemplateServiceImpl")
public class StaticTemplateServiceImpl
extends AbstractTemplateService
implements StaticTemplateService {
    @Autowired
    private NebulaStaticPersistentService nebulaStaticPersistentService;
    @Autowired
    private TemplateRepository templateRepository;
    @Autowired
    private TemplatePropertyRepository templatePropertyRepository;
    @Autowired
    private TemplateRelationRepository templateRelationRepository;
    @Autowired
    private TemplateMaintainerService templateMaintainerService;
    @Autowired
    private TemplateEventService templateEventService;
    @Autowired
    private TemplateVisibilityService templateVisibilityService;
    @Autowired
    private TemplateItemService templateItemService;
    @Autowired
    private TemplateGroupService templateGroupService;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private InstanceRepository instanceRepository;
    @Autowired
    private InstanceService instanceService;
    @Autowired
    private UserService userService;
    @Autowired
    private PlatformContext platformContext;
    @Autowired
    private StaticTemplateMergeService staticTemplateMergeService;

    @Transactional
    @CacheEvict(cacheNames={"template"}, allEntries=true)
    public TemplateEntity initStaticTemplate(TemplateEntity template, Principal principal, boolean initVisibilities) {
        List persistentOneToOneRelations;
        List persistentOneToManyRelations;
        List<PersistentRelation> persistentManyToRelations;
        String id = template.getId();
        Validate.isTrue((boolean)StringUtils.isBlank((CharSequence)id), (String)"\u8868\u5355\u6a21\u677f\u521d\u59cb\u5316\u65f6\uff0c\u4e0d\u80fd\u4f20\u5165\u8868\u5355\u6a21\u677f\u7f16\u53f7!!", (Object[])new Object[0]);
        template.setId(null);
        String cversion = template.getCversion();
        Validate.notBlank((CharSequence)cversion, (String)"\u65b0\u7684\u8868\u5355\u6a21\u677f\u7684\u7248\u672c\u53f7\u4fe1\u606f\u5fc5\u987b\u6307\u5b9a!!", (Object[])new Object[0]);
        String name = template.getName();
        Validate.notBlank((CharSequence)name, (String)"\u65b0\u7684\u8868\u5355\u6a21\u677f\u7684\u540d\u79f0\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String type = template.getType();
        Validate.notBlank((CharSequence)type, (String)"\u8868\u5355\u6a21\u677f\u7c7b\u578b\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)type, (CharSequence)FormTemplateTypeEnum.STATIC.getType()), (String)"\u76ee\u6807\u8868\u5355\u6a21\u677f\u7c7b\u578b\u53ea\u652f\u6301\uff08static\uff09\u9759\u6001\u6a21\u677f\u7c7b\u578b!!", (Object[])new Object[0]);
        String persistentClassName = template.getPersistentClassName();
        PersistentClass persistentClass = this.nebulaStaticPersistentService.findByPersistentClass(persistentClassName);
        Validate.notNull((Object)persistentClass, (String)"\u6ca1\u6709\u627e\u5230\u6307\u5b9a\u7684\u9759\u6001\u6a21\u578b\u63cf\u8ff0\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        template.setCode(persistentClass.getClassName());
        TemplateEntity currentTemplate = this.templateRepository.findByCodeAndCversion(template.getCode(), cversion);
        Validate.isTrue((currentTemplate == null ? 1 : 0) != 0, (String)"\u5f53\u524d\u6307\u5b9a\u7684\u8868\u5355\u6a21\u677f\u7f16\u53f7\u548c\u7248\u672c\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        template.setProjectName(this.platformContext.getAppName());
        super.saveTemplate(template, principal);
        List persistentProperties = persistentClass.getProperties();
        Set<TemplatePropertyEntity> templateProperties = this.initStaticProperties(template, persistentProperties);
        if (!CollectionUtils.isEmpty(templateProperties)) {
            templateProperties.forEach(p -> p.setProjectName(this.platformContext.getAppName()));
        }
        this.templatePropertyRepository.saveAll(templateProperties);
        template.setProperties(templateProperties);
        List persistentRelations = persistentClass.getRelations();
        if (persistentRelations != null && !persistentRelations.isEmpty() && !CollectionUtils.isEmpty(persistentManyToRelations = persistentRelations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.ManyToMany || item.getRelationType() == PersistentRelation.RelationType.ManyToOne).collect(Collectors.toList()))) {
            Set<TemplateRelationEntity> templateRelations = this.initStaticRelations(template, persistentManyToRelations);
            if (!CollectionUtils.isEmpty(templateRelations)) {
                templateRelations.forEach(t -> t.setProjectName(this.platformContext.getAppName()));
            }
            this.templateRelationRepository.saveAll(templateRelations);
            template.setRelations(templateRelations);
        }
        if (persistentRelations != null && !persistentRelations.isEmpty() && !CollectionUtils.isEmpty(persistentOneToManyRelations = persistentRelations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.OneToMany).collect(Collectors.toList()))) {
            HashSet<TemplateItemEntity> items = new HashSet<TemplateItemEntity>();
            for (PersistentRelation persistentOneToManyRelationItem : persistentOneToManyRelations) {
                String oneToManyPersistentClassName = persistentOneToManyRelationItem.getPropertyClass();
                PersistentClass oneToManyPersistentClass = this.nebulaStaticPersistentService.findByPersistentClass(oneToManyPersistentClassName);
                Validate.notNull((Object)oneToManyPersistentClass, (String)"\u5728\u521d\u59cb\u5316\u4e3b\u9759\u6001\u6a21\u578b\u65f6\u53d1\u73b0NULL\u5173\u8054\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u8868\u5355\u5f15\u64ce\u5f00\u53d1\u56e2\u961f!!", (Object[])new Object[0]);
                TemplateItemEntity currentTemplateItem = this.templateItemService.initStaticItems(template, null, persistentOneToManyRelationItem, oneToManyPersistentClass);
                currentTemplateItem.setProjectName(this.platformContext.getAppName());
                items.add(currentTemplateItem);
            }
            template.setItemRelations(items);
        }
        if (persistentRelations != null && !persistentRelations.isEmpty() && !CollectionUtils.isEmpty(persistentOneToOneRelations = persistentRelations.stream().filter(item -> item.getRelationType() == PersistentRelation.RelationType.OneToOne).collect(Collectors.toList()))) {
            HashSet<TemplateGroupEntity> groups = new HashSet<TemplateGroupEntity>();
            for (PersistentRelation oneToOneRelationItem : persistentOneToOneRelations) {
                String oneToOnePersistentClassName = oneToOneRelationItem.getPropertyClass();
                PersistentClass oneToOnePersistentClass = this.nebulaStaticPersistentService.findByPersistentClass(oneToOnePersistentClassName);
                Validate.notNull((Object)oneToOnePersistentClass, (String)"\u5728\u521d\u59cb\u5316\u4e3b\u9759\u6001\u6a21\u578b\u65f6\u53d1\u73b0NULL\u5173\u8054\u4fe1\u606f\uff0c\u8bf7\u8054\u7cfb\u8868\u5355\u5f15\u64ce\u5f00\u53d1\u56e2\u961f!!", (Object[])new Object[0]);
                TemplateGroupEntity currentTemplateGroup = this.templateGroupService.initStaticGroups(template, oneToOneRelationItem, oneToOnePersistentClass);
                currentTemplateGroup.setProjectName(this.platformContext.getAppName());
                groups.add(currentTemplateGroup);
            }
            template.setGroupRelations(groups);
        }
        if (initVisibilities) {
            Set<TemplateVisibilityEntity> templateVisibilities = this.templateVisibilityService.initStaticTemplateVisibilities(template.getId(), persistentClass);
            template.setVisibility(templateVisibilities);
        }
        return template;
    }

    private Set<TemplatePropertyEntity> initStaticProperties(TemplateEntity template, List<PersistentProperty> persistentProperties) {
        LinkedHashSet<TemplatePropertyEntity> templateProperties = new LinkedHashSet<TemplatePropertyEntity>();
        for (PersistentProperty persistentProperty : persistentProperties) {
            TemplatePropertyEntity property = new TemplatePropertyEntity();
            property.setCanInsert(persistentProperty.getCanInsert());
            property.setCanUpdate(persistentProperty.getCanUpdate());
            property.setUnique(persistentProperty.getUnique());
            property.setIndex(persistentProperty.getIndex());
            property.setNullable(persistentProperty.getNullable());
            property.setPrimaryKey(persistentProperty.getPrimaryKey());
            property.setPropertyClassName(persistentProperty.getPropertyClass());
            String propertyDbName = persistentProperty.getPropertyDbName() == null ? "" : persistentProperty.getPropertyDbName();
            Validate.isTrue((propertyDbName != null && propertyDbName.length() <= 64 ? 1 : 0) != 0, (String)"\u5728\u521d\u59cb\u5316\u65f6\u53d1\u73b0\u5b57\u6bb5\u7684\u6570\u636e\u5e93\u5c5e\u6027\u63cf\u8ff0[%s]\uff0c\u957f\u5ea6\u8d85\u8fc7\u4e8664\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{propertyDbName});
            property.setPropertyDbName(propertyDbName);
            property.setPropertyDesc(persistentProperty.getPropertyDesc());
            String propertyName = persistentProperty.getPropertyName();
            Validate.isTrue((!StringUtils.isBlank((CharSequence)propertyName) && propertyName.length() <= 64 ? 1 : 0) != 0, (String)"\u5728\u521d\u59cb\u5316\u65f6\u53d1\u73b0\u5b57\u6bb5[%s]\u7684\u957f\u5ea6\u8d85\u8fc7\u4e8664\u4e2a\u5b57\u7b26\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[]{propertyName});
            property.setPropertyName(propertyName);
            property.setDefaultController(persistentProperty.getDefaultType() != null ? persistentProperty.getDefaultType() : "");
            property.setDefaultKeys(persistentProperty.getDefaultKeys());
            property.setDefaultValues(persistentProperty.getDefaultValues());
            property.setMaxLen(persistentProperty.getMaxLen());
            property.setId(null);
            property.setCurrentTemplate(template);
            property.setCurrentGroup(null);
            property.setCurrentItem(null);
            property.setProjectName(this.platformContext.getAppName());
            templateProperties.add(property);
        }
        return templateProperties;
    }

    private Set<TemplateRelationEntity> initStaticRelations(TemplateEntity template, List<PersistentRelation> persistentRelations) {
        LinkedHashSet<TemplateRelationEntity> templateRelations = new LinkedHashSet<TemplateRelationEntity>();
        for (PersistentRelation persistentRelationItem : persistentRelations) {
            TemplateRelationEntity relationModel = new TemplateRelationEntity();
            relationModel.setCanInsert(persistentRelationItem.getCanInsert());
            relationModel.setCanUpdate(persistentRelationItem.getCanUpdate());
            relationModel.setIndex(persistentRelationItem.getIndex());
            relationModel.setNullable(persistentRelationItem.getNullable());
            relationModel.setPropertyClassName(persistentRelationItem.getPropertyClass());
            relationModel.setPropertyDbName(persistentRelationItem.getPropertyDbName() == null ? "" : persistentRelationItem.getPropertyDbName());
            relationModel.setPropertyDesc(persistentRelationItem.getPropertyDesc());
            relationModel.setPropertyName(persistentRelationItem.getPropertyName());
            relationModel.setRelationType(persistentRelationItem.getRelationType().toString());
            relationModel.setCurrentView(null);
            relationModel.setId(null);
            relationModel.setTargetTableName("");
            relationModel.setCurrentTemplate(template);
            relationModel.setCurrentGroup(null);
            relationModel.setCurrentItem(null);
            relationModel.setProjectName(this.platformContext.getAppName());
            templateRelations.add(relationModel);
        }
        return templateRelations;
    }

    @Transactional
    @CacheEvict(cacheNames={"template"}, allEntries=true)
    public TemplateEntity upgradeStaticTemplate(String templateId, String newVersion, boolean updateInstance, Principal principal) {
        Validate.notBlank((CharSequence)templateId, (String)"\u5347\u7ea7\u65f6,\u539f\u59cb\u6307\u5b9a\u7684templateId\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)newVersion, (String)"\u5347\u7ea7\u65f6,\u65b0\u7684\u7248\u672c\u4fe1\u606f\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        TemplateEntity currentTemplate = this.templateRepository.findById(templateId).orElse(null);
        Validate.notNull((Object)currentTemplate, (String)"\u672a\u627e\u5230\u6307\u5b9a\u7684\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)currentTemplate.getType(), (CharSequence)FormTemplateTypeEnum.STATIC.getType()), (String)"\u8be5\u5347\u7ea7\u65b9\u6cd5\u53ea\u9002\u7528\u4e8e\u201c\u9759\u6001\u8868\u5355\u6a21\u677f\u201d!!", (Object[])new Object[0]);
        TemplateEntity exsitTemplate = this.templateRepository.findByCodeAndCversion(currentTemplate.getCode(), newVersion);
        Validate.isTrue((exsitTemplate == null ? 1 : 0) != 0, (String)"\u6307\u5b9a\u7684\u7248\u672c\u7f16\u53f7\u4fe1\u606f\u5df2\u7ecf\u5728\u6307\u5b9a\u7684code[%s]\u4e2d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u6307\u5b9a\u7248\u672c\u7f16\u53f7\u4fe1\u606f!!", (Object[])new Object[]{currentTemplate.getCode()});
        Validate.notNull((Object)principal, (String)"\u5fc5\u987b\u6307\u5b9a\u64cd\u4f5c\u8005\u4fe1\u606f!!", (Object[])new Object[0]);
        String account = principal.getName();
        UserVo user = this.userService.findByAccount(account);
        Validate.notNull((Object)user, (String)"\u672a\u627e\u5230\u4efb\u4f55\u521b\u5efa\u8005\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
        String type = currentTemplate.getType();
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)type, (CharSequence)FormTemplateTypeEnum.STATIC.getType()), (String)"\u76ee\u524d\u672c\u63a5\u53e3\u53ea\u652f\u6301\u57fa\u4e8e\u9759\u6001\u6a21\u578b\u7684\u9759\u6001\u6a21\u677f\u5347\u7ea7", (Object[])new Object[0]);
        String persistentClassName = currentTemplate.getPersistentClassName();
        Validate.notBlank((CharSequence)persistentClassName, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u9759\u6001\u6a21\u578b\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u5e93\u6570\u636e!!", (Object[])new Object[0]);
        PersistentClass currentPersistentClass = this.nebulaStaticPersistentService.findByPersistentClass(persistentClassName);
        Validate.notNull((Object)currentPersistentClass, (String)"\u672a\u53d1\u73b0\u6307\u5b9a\u7684\u9759\u6001\u6a21\u578b\u5b9a\u4e49\uff0c\u8bf7\u68c0\u67e5[%s]", (Object[])new Object[]{currentPersistentClass});
        TemplateEntity newTemplate = new TemplateEntity();
        newTemplate.setCode(currentTemplate.getCode());
        newTemplate.setCreateTime(new Date());
        newTemplate.setCreator(account);
        newTemplate.setCversion(newVersion);
        newTemplate.setDomain(currentTemplate.getDomain());
        newTemplate.setFormStyle(currentTemplate.getFormStyle());
        newTemplate.setName(currentTemplate.getName());
        newTemplate.setPersistentClassName(currentTemplate.getPersistentClassName());
        newTemplate.setProjectName(this.platformContext.getAppName());
        newTemplate.setRepositoryEntity(currentTemplate.getRepositoryEntity());
        newTemplate.setTstatus(currentTemplate.getTstatus());
        newTemplate.setType(currentTemplate.getType());
        newTemplate.setModifyTime(new Date());
        newTemplate = this.initStaticTemplate(newTemplate, principal, false);
        String newTemplateId = newTemplate.getId();
        super.upgradeTemplateLayout(templateId, newTemplateId, newTemplate);
        super.upgradeTemplateEvent(templateId, newTemplateId, newTemplate);
        super.upgradeTemplateVisibility(templateId, newTemplateId, newTemplate);
        this.templateService.updateDefaultVersion(newTemplateId);
        this.bindingTemplateMaintainer(templateId, newTemplateId);
        if (updateInstance) {
            this.instanceService.updateTemplate(newTemplate);
        }
        return newTemplate;
    }

    @Transactional
    @CacheEvict(cacheNames={"template"}, allEntries=true)
    public void deleteById(String templateId) {
        Validate.notBlank((CharSequence)templateId, (String)"\u8fdb\u884c\u5220\u9664\u65f6\uff0c\u6a21\u677f\u4fe1\u606f\u7f16\u53f7\u5fc5\u987b\u586b\u5165!!", (Object[])new Object[0]);
        int insCount = this.instanceRepository.countByTemplateId(templateId);
        Validate.isTrue((insCount == 0 ? 1 : 0) != 0, (String)"\u5f53\u524d\u6307\u5b9a\u7684\u6a21\u677f\u4fe1\u606f\u5df2\u5b58\u5728\u5b9e\u4f8b\uff0c\u4e0d\u5141\u8bb8\u88ab\u5220\u9664!!", (Object[])new Object[0]);
        this.templateVisibilityService.deleteByTemplateId(templateId);
        this.templateEventService.deleteByTemplateId(templateId);
        this.templateRepository.deleteByTemplateId(templateId);
    }

    @Transactional
    public TemplateEntity merge(String refTemplateId, String templateId, String name, String version, Principal principal) {
        StaticTemplateMergeModel model = new StaticTemplateMergeModel();
        model.setReferenceTemplateId(refTemplateId);
        model.setMergedTemplateId(templateId);
        model.setNewTemplateName(name);
        model.setNewTemplateVersion(version);
        Validate.notNull((Object)principal, (String)"\u5fc5\u987b\u6307\u5b9a\u64cd\u4f5c\u8005\u4fe1\u606f!!", (Object[])new Object[0]);
        model.setAccount(principal.getName());
        return this.staticTemplateMergeService.merge(model);
    }

    private void bindingTemplateMaintainer(String templateId, String newTemplateId) {
        Set<TemplateMaintainerEntity> maintainers = this.templateMaintainerService.findByTemplateId(templateId);
        if (!CollectionUtils.isEmpty(maintainers)) {
            String[] accounts = maintainers.stream().map(TemplateMaintainerEntity::getUserAccount).collect(Collectors.toList()).toArray(new String[maintainers.size()]);
            this.templateMaintainerService.binding(newTemplateId, accounts);
        }
    }
}

