/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.model.MigrateImportModel;
import com.bizunited.platform.common.util.ZipFileUtils;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateGroupEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemExcelEntity;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.repository.TemplateItemExcelRepository;
import com.bizunited.platform.kuiper.starter.service.TemplateItemExcelService;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipFile;
import javax.transaction.Transactional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="TemplateItemExcelServiceImpl")
public class TemplateItemExcelServiceImpl
implements TemplateItemExcelService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateItemExcelServiceImpl.class);
    @Autowired
    private TemplateItemExcelRepository templateItemExcelRepository;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private VenusFileService fileUpdateService;
    @Autowired
    private PlatformContext platformContext;

    @Override
    @Transactional
    public TemplateItemExcelEntity save(TemplateItemExcelEntity templateItemExcelEntity) {
        Validate.notNull((Object)templateItemExcelEntity, (String)"\u521b\u5efa\u65f6\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)templateItemExcelEntity.getTemplateId(), (String)"\u521b\u5efa\u65f6\u8868\u5355\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)templateItemExcelEntity.getTemplateItemId(), (String)"\u521b\u5efa\u65f6\u8868\u5355\u660e\u7ec6\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)templateItemExcelEntity.getFileName(), (String)"\u521b\u5efa\u65f6\u6587\u4ef6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)templateItemExcelEntity.getOriginalFileName(), (String)"\u521b\u5efa\u65f6\u4e0a\u4f20\u6587\u4ef6\u539f\u59cb\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)templateItemExcelEntity.getFilePath(), (String)"\u521b\u5efa\u65f6\u4e0a\u4f20\u6587\u4ef6\u76f8\u5bf9\u8def\u5f84\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notNull((Object)templateItemExcelEntity.getCreateDate(), (String)"\u521b\u5efa\u65f6\u4e0a\u4f20\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        TemplateItemExcelEntity exist = this.templateItemExcelRepository.findByTemplateItemId(templateItemExcelEntity.getTemplateItemId());
        if (null != exist) {
            this.delete(exist.getId());
        }
        templateItemExcelEntity.setProjectName(this.platformContext.getAppName());
        return (TemplateItemExcelEntity)this.templateItemExcelRepository.save(templateItemExcelEntity);
    }

    @Override
    public List<TemplateItemExcelEntity> findByTemplate(String templateId) {
        if (StringUtils.isBlank((CharSequence)templateId)) {
            return new ArrayList<TemplateItemExcelEntity>();
        }
        return this.templateItemExcelRepository.findByTemplateId(templateId);
    }

    @Override
    public List<TemplateItemExcelEntity> findByTemplateGroup(String templateGroupId) {
        if (StringUtils.isBlank((CharSequence)templateGroupId)) {
            return new ArrayList<TemplateItemExcelEntity>();
        }
        return this.templateItemExcelRepository.findByTemplateGroupId(templateGroupId);
    }

    @Override
    public TemplateItemExcelEntity findByTemplateItem(String templateItemId) {
        if (StringUtils.isBlank((CharSequence)templateItemId)) {
            return null;
        }
        return this.templateItemExcelRepository.findByTemplateItemId(templateItemId);
    }

    @Override
    @Transactional
    public void delete(String templateItemExcelEntityId) {
        TemplateItemExcelEntity excelEntity = this.templateItemExcelRepository.findById(templateItemExcelEntityId).orElse(null);
        if (excelEntity == null) {
            return;
        }
        this.fileUpdateService.deleteFile(excelEntity.getFilePath(), excelEntity.getOriginalFileName(), excelEntity.getFileName());
        this.templateItemExcelRepository.deleteById(templateItemExcelEntityId);
        this.templateItemExcelRepository.flush();
    }

    @Override
    @Transactional
    public void importData(TemplateEntity template, List<TemplateItemExcelEntity> templateItemExcels, MigrateImportModel importModel) {
        if (CollectionUtils.isEmpty(templateItemExcels)) {
            return;
        }
        TemplateEntity dbTemplate = this.templateService.findDetailsById(template.getId());
        Validate.notNull((Object)dbTemplate, (String)"\u672a\u83b7\u53d6\u5230\u4fdd\u5b58\u7684\u6a21\u7248\u5bf9\u8c61", (Object[])new Object[0]);
        for (TemplateItemExcelEntity itemExcel : templateItemExcels) {
            importModel.appendLine("\u5bfc\u5165\u6a21\u7248\u660e\u7ec6\u9879excel\u6a21\u7248\uff1a\u5206\u7ec4\u5c5e\u6027\u540d=%s, \u660e\u7ec6\u9879\u5c5e\u6027\u540d=%s", new Object[]{itemExcel.getGroupPropertyName(), itemExcel.getItemPropertyName()});
            itemExcel.setTemplateId(dbTemplate.getId());
            if (StringUtils.isBlank((CharSequence)itemExcel.getTemplateGroupId())) {
                this.importData(dbTemplate.getItemRelations(), itemExcel, importModel);
                continue;
            }
            this.importDataByGroup(template.getGroupRelations(), itemExcel, importModel);
        }
    }

    private void importDataByGroup(Set<TemplateGroupEntity> groups, TemplateItemExcelEntity itemExcel, MigrateImportModel importModel) {
        Validate.notEmpty(groups, (String)"\u8868\u5355\u6a21\u7248\u7684\u5206\u7ec4\u4e3a\u7a7a", (Object[])new Object[0]);
        Set collect = groups.stream().filter(g -> g.getPropertyName().equals(itemExcel.getGroupPropertyName())).collect(Collectors.toSet());
        Validate.notEmpty(collect, (String)"\u660e\u7ec6\u9879\u5bfc\u5165\u6a21\u7248\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5206\u7ec4\u5c5e\u6027\uff1a%s", (Object[])new Object[]{itemExcel.getGroupPropertyName()});
        TemplateGroupEntity group = (TemplateGroupEntity)collect.iterator().next();
        itemExcel.setTemplateGroupId(group.getId());
        this.importData(group.getItemRelations(), itemExcel, importModel);
    }

    private void importData(Set<TemplateItemEntity> items, TemplateItemExcelEntity itemExcel, MigrateImportModel importModel) {
        Validate.notEmpty(items, (String)"\u8868\u5355\u6a21\u7248\u7684\u660e\u7ec6\u9879\u4e3a\u7a7a:\u5206\u7ec4\u5c5e\u6027=%s", (Object[])new Object[]{itemExcel.getGroupPropertyName()});
        Set excelItems = items.stream().filter(i -> i.getPropertyName().equals(itemExcel.getItemPropertyName())).collect(Collectors.toSet());
        Validate.notEmpty(excelItems, (String)"\u660e\u7ec6\u9879\u5bfc\u5165\u6a21\u7248\u672a\u627e\u5230\u5bf9\u5e94\u7684\u660e\u7ec6\u9879\u5c5e\u6027\uff1a\u5206\u7ec4\u5c5e\u6027\u540d=%s, \u660e\u7ec6\u9879\u5c5e\u6027\u540d=%s", (Object[])new Object[]{itemExcel.getGroupPropertyName(), itemExcel.getItemPropertyName()});
        TemplateItemEntity item = (TemplateItemEntity)excelItems.iterator().next();
        itemExcel.setTemplateItemId(item.getId());
        itemExcel.setCreateDate(new Date());
        itemExcel.setId(null);
        this.save(itemExcel);
        ZipFile zipFile = importModel.getZipFile();
        try {
            byte[] bytes = ZipFileUtils.readZipFile((ZipFile)zipFile, (String)itemExcel.getFilePath(), (String)itemExcel.getFileName());
            this.fileUpdateService.saveFile(itemExcel.getFilePath(), itemExcel.getOriginalFileName(), itemExcel.getFileName(), bytes);
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            throw new IllegalArgumentException(String.format("\u8bfb\u53d6\u660e\u7ec6\u9879\u5bfc\u5165\u6a21\u7248\u51fa\u9519\uff1a%s/%s", itemExcel.getFilePath(), itemExcel.getFileName()), e);
        }
    }
}

