/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.internal;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.enums.ImportExecuteModeEnum;
import com.bizunited.platform.common.model.MigrateImportModel;
import com.bizunited.platform.common.util.ZipFileUtils;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateEventEntity;
import com.bizunited.platform.kuiper.entity.TemplateGroupEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemExcelEntity;
import com.bizunited.platform.kuiper.entity.TemplateLayoutEntity;
import com.bizunited.platform.kuiper.entity.TemplatePropertyEntity;
import com.bizunited.platform.kuiper.entity.TemplateRelationEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityEntity;
import com.bizunited.platform.kuiper.service.DynamicTemplateService;
import com.bizunited.platform.kuiper.service.StaticTemplateService;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.common.enums.FormTemplateTypeEnum;
import com.bizunited.platform.kuiper.starter.repository.TemplateGroupRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplateItemRepository;
import com.bizunited.platform.kuiper.starter.repository.TemplateRepository;
import com.bizunited.platform.kuiper.starter.service.KuiperToolkitService;
import com.bizunited.platform.kuiper.starter.service.TemplateEventService;
import com.bizunited.platform.kuiper.starter.service.TemplateItemExcelService;
import com.bizunited.platform.kuiper.starter.service.TemplateLayoutService;
import com.bizunited.platform.kuiper.starter.service.TemplateVisibilityService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.SerializationUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="TemplateServiceImpl")
public class TemplateServiceImpl
implements TemplateService {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateServiceImpl.class);
    private static final String NULLABLE = "nullable";
    private static final String FIELD_NAME = "fieldName";
    private static final String TYPE = "type";
    private static final String DESC = "desc";
    private static final String OBJECT = "Object";
    private static final String OBJECT_ARRAY = "ObjectArray";
    private static final String KEY = "key";
    private static final String FORMAT_S = "%s-%s";
    private static final String VALIDATE_MESSAGE = "\u672a\u627e\u5230\u6307\u5b9a\u7684\u6a21\u677f\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!";
    @Autowired
    private TemplateRepository templateRepository;
    @Autowired
    private TemplateGroupRepository templateGroupRepository;
    @Autowired
    private TemplateItemRepository templateItemRepository;
    @Autowired
    private TemplateEventService templateEventService;
    @Autowired
    private TemplateVisibilityService templateVisibilityService;
    @Autowired
    private TemplateLayoutService templateLayoutService;
    @Autowired
    @Qualifier(value="KuiperToolkitService")
    private KuiperToolkitService kuiperToolkitService;
    @Autowired
    private StaticTemplateService staticTemplateService;
    @Autowired
    private DynamicTemplateService dynamicTemplateService;
    @Autowired
    private TemplateItemExcelService templateItemExcelService;
    @Autowired
    private PlatformContext platformContext;

    @Cacheable(cacheNames={"template"}, key="'findById_' + #id", sync=true)
    public TemplateEntity findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        Optional op = this.templateRepository.findById(id);
        TemplateEntity currentTemplate = op.orElse(null);
        if (currentTemplate == null) {
            return null;
        }
        return (TemplateEntity)this.kuiperToolkitService.copyObjectByWhiteList(currentTemplate, TemplateEntity.class, LinkedHashSet.class, LinkedList.class, new String[0]);
    }

    @Cacheable(cacheNames={"template"}, key="'findByCode_' + #code", sync=true)
    public List<TemplateEntity> findByCode(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return new ArrayList<TemplateEntity>();
        }
        List<TemplateEntity> templates = this.templateRepository.findByCode(code);
        if (templates == null || templates.isEmpty()) {
            return new ArrayList<TemplateEntity>();
        }
        Collection resutls = this.kuiperToolkitService.copyCollectionByWhiteList(templates, TemplateEntity.class, TemplateEntity.class, LinkedHashSet.class, LinkedList.class, new String[0]);
        return new LinkedList<TemplateEntity>(resutls);
    }

    public TemplateEntity findByDefaultVersion(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        return this.templateRepository.findByDefaultVersion(code);
    }

    @Cacheable(cacheNames={"template"}, key="'findDetailsById_' + #id", sync=true)
    public TemplateEntity findDetailsById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        TemplateEntity currentTemplate = this.templateRepository.findDetailsById(id);
        if (currentTemplate == null) {
            return null;
        }
        Set properties = currentTemplate.getProperties();
        currentTemplate.setProperties(this.sortedProperties(properties));
        Set relations = currentTemplate.getRelations();
        currentTemplate.setRelations(this.sortedRelations(relations));
        Set<TemplateGroupEntity> templateGroups = this.templateGroupRepository.findDetailsByParentTemplate(id);
        if (templateGroups != null) {
            for (TemplateGroupEntity templateGroup : templateGroups) {
                templateGroup.setProperties(this.sortedProperties(templateGroup.getProperties()));
                templateGroup.setRelations(this.sortedRelations(templateGroup.getRelations()));
                Set templateItems = templateGroup.getItemRelations();
                if (templateItems == null) continue;
                for (TemplateItemEntity templateItem : templateItems) {
                    templateItem.setProperties(this.sortedProperties(templateItem.getProperties()));
                    templateItem.setRelations(this.sortedRelations(templateItem.getRelations()));
                }
            }
        }
        currentTemplate.setGroupRelations(templateGroups);
        Set<TemplateItemEntity> templateItems = this.templateItemRepository.findDetailsByParentTemplate(id);
        if (templateItems != null) {
            for (TemplateItemEntity templateItem : templateItems) {
                templateItem.setProperties(this.sortedProperties(templateItem.getProperties()));
                templateItem.setRelations(this.sortedRelations(templateItem.getRelations()));
            }
        }
        currentTemplate.setItemRelations(templateItems);
        return (TemplateEntity)this.kuiperToolkitService.copyObjectByWhiteList(currentTemplate, TemplateEntity.class, LinkedHashSet.class, LinkedList.class, new String[]{"properties", "relations", "creator", "groupRelations", "groupRelations.properties", "groupRelations.relations", "groupRelations.itemRelations", "groupRelations.itemRelations.properties", "groupRelations.itemRelations.relations", "itemRelations", "itemRelations.properties", "itemRelations.relations"});
    }

    public List<TemplateEntity> findByFormStyle(String formStyle) {
        if (StringUtils.isBlank((CharSequence)formStyle)) {
            return Lists.newArrayList();
        }
        String appName = this.platformContext.getAppName();
        if (StringUtils.isNotBlank((CharSequence)appName)) {
            return this.templateRepository.findByFormStyleAndProjectName(formStyle, appName);
        }
        return this.templateRepository.findByFormStyleAndBlankProjectName(formStyle);
    }

    public TemplateEntity findByCodeAndCversion(String templateCode, String cversion) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{templateCode, cversion})) {
            return null;
        }
        return this.templateRepository.findByCodeAndCversion(templateCode, cversion);
    }

    public TemplateEntity findDetailsByCodeAndVersion(String code, String version) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{code, version})) {
            return null;
        }
        TemplateEntity template = this.templateRepository.findByCodeAndCversion(code, version);
        if (template == null) {
            return null;
        }
        return this.findDetailsById(template.getId());
    }

    public TemplateEntity findDetailsByCodeAndDefaultVersion(String code) {
        if (StringUtils.isBlank((CharSequence)code)) {
            return null;
        }
        TemplateEntity template = this.templateRepository.findByDefaultVersion(code);
        if (template == null) {
            return null;
        }
        return this.findDetailsById(template.getId());
    }

    public List<TemplateEntity> findAllByConditions(TemplateEntity condition) {
        condition = (TemplateEntity)ObjectUtils.defaultIfNull((Object)condition, (Object)new TemplateEntity());
        condition.setProjectName(this.platformContext.getAppName());
        return this.templateRepository.findAllByConditions(condition);
    }

    public List<TemplateEntity> findDetailsByIds(String[] ids) {
        if (ArrayUtils.isEmpty((Object[])ids)) {
            return Lists.newArrayList();
        }
        return this.templateRepository.findDetailsByIds(ids);
    }

    @Transactional(value=Transactional.TxType.REQUIRES_NEW)
    public void importData(MigrateImportModel importModel) {
        Validate.notNull((Object)importModel, (String)"\u5bfc\u5165\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        ZipFile zipFile = importModel.getZipFile();
        Validate.notNull((Object)zipFile, (String)"\u5bfc\u5165\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        Validate.notNull((Object)importModel.getExecuteMode(), (String)"\u6267\u884c\u6a21\u5f0f\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        importModel.appendLine("\u5f00\u59cb\u5bfc\u5165\u6570\u636e");
        ZipEntry templateEntry = zipFile.getEntry("formTemplate.in");
        if (templateEntry == null) {
            importModel.appendLine("\u5bfc\u5165\u538b\u7f29\u5305\u4e2d\u672a\u53d1\u73b0\u6570\u636e\u6587\u4ef6\uff0c\u8bf7\u68c0\u67e5");
            return;
        }
        try (InputStream is = zipFile.getInputStream(templateEntry);
             ObjectInputStream ois = new ObjectInputStream(is);){
            List templates = (List)ois.readObject();
            Map templateItemExcel = (Map)ois.readObject();
            if (CollectionUtils.isEmpty((Collection)templates)) {
                importModel.appendLine("\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u6570\u636e");
                return;
            }
            this.importData(templates, templateItemExcel, importModel);
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            importModel.append("\u8bfb\u53d6\u6a21\u7248\u6570\u636e\u5931\u8d25\uff1a").appendLine(e.getMessage());
        }
    }

    private void importData(List<TemplateEntity> templates, Map<String, List<TemplateItemExcelEntity>> templateItemExcel, MigrateImportModel importModel) {
        importModel.setTotalCount(templates.size());
        for (int i = 0; i < templates.size(); ++i) {
            TemplateEntity template = templates.get(i);
            importModel.appendLine(StringUtils.join((Object[])new Serializable[]{"--------[", Integer.valueOf(i + 1), "]----------"}));
            String key = String.format("%s|%s", template.getCode(), template.getCversion());
            List<TemplateItemExcelEntity> templateItemExcels = templateItemExcel.get(key);
            this.importData(template, templateItemExcels, importModel);
        }
    }

    private void importData(TemplateEntity template, List<TemplateItemExcelEntity> templateItemExcels, MigrateImportModel importModel) {
        importModel.appendLine(String.format("\u5f00\u59cb\u5bfc\u5165\u6570\u636e\uff1a\u7f16\u53f7=%s,\u7248\u672c\u53f7=%s", template.getCode(), template.getCversion()));
        ImportExecuteModeEnum executeMode = importModel.getExecuteMode();
        TemplateEntity dbTemplate = this.templateRepository.findByCodeAndCversion(template.getCode(), template.getCversion());
        if (dbTemplate != null && ImportExecuteModeEnum.SKIP == executeMode) {
            importModel.appendLine("\u6a21\u7248\u6570\u636e\u5df2\u5b58\u5728\uff0c\u6267\u884c\u8df3\u8fc7");
            importModel.addSkipCount();
            return;
        }
        if (dbTemplate != null && ImportExecuteModeEnum.UPDATE == executeMode) {
            importModel.appendLine("\u6a21\u7248\u6570\u636e\u5df2\u5b58\u5728\uff0c\u6267\u884c\u8df3\u8fc7");
            importModel.addSkipCount();
            return;
        }
        if (dbTemplate != null && ImportExecuteModeEnum.ADD == executeMode) {
            this.handleCreateDataOnExist(template, templateItemExcels, importModel);
            return;
        }
        if (dbTemplate == null) {
            this.handleCreateData(template, templateItemExcels, importModel);
            return;
        }
    }

    private void handleCreateDataOnExist(TemplateEntity template, List<TemplateItemExcelEntity> templateItemExcels, MigrateImportModel importModel) {
        String newVersion;
        long versionCount;
        importModel.appendLine("\u6a21\u7248\u6570\u636e\u5df2\u5b58\u5728\uff0c\u6267\u884c\u7248\u672c\u5347\u7ea7\u5bfc\u5165");
        int count = 1;
        do {
            newVersion = StringUtils.join((Object[])new Serializable[]{template.getCversion(), "_", Integer.valueOf(count)});
            ++count;
        } while ((versionCount = this.templateRepository.countByCodeAndVersion(template.getCode(), newVersion)) > 0L);
        importModel.append("\u751f\u6210\u65b0\u7684\u7248\u672c\u53f7\uff1a").appendLine(newVersion);
        importModel.appendLine("\u5bfc\u5165\u6a21\u7248\u6570\u636e");
        template.setCversion(newVersion);
        this.handleCreateData(template, templateItemExcels, importModel);
    }

    private void handleCreateData(TemplateEntity template, List<TemplateItemExcelEntity> templateItemExcels, MigrateImportModel importModel) {
        importModel.appendLine("\u5bfc\u5165\u65b0\u589e\u6a21\u7248\u6570\u636e\uff1a\u7f16\u53f7=%s\uff0c\u7248\u672c=%s", new Object[]{template.getCode(), template.getCversion()});
        TemplateEntity importTemplate = (TemplateEntity)SerializationUtils.clone((Serializable)template);
        template.setDefaultVersion(Boolean.valueOf(false));
        List<TemplateEntity> templateEntities = this.templateRepository.findByCode(template.getCode());
        if (CollectionUtils.isEmpty(templateEntities)) {
            template.setDefaultVersion(Boolean.valueOf(true));
        }
        this.handleTemplateDataId(template);
        Principal principal = SecurityUtils.getPrincipal();
        if (FormTemplateTypeEnum.DYNAMIC.getType().equals(template.getType())) {
            importModel.appendLine("\u521d\u59cb\u5316\u52a8\u6001\u6a21\u7248");
            this.handleDynamicTemplate(template);
            TemplateEntity dbTemplate = this.dynamicTemplateService.initDynamicTemplate(template, principal, true);
            importTemplate.setId(dbTemplate.getId());
        } else if (FormTemplateTypeEnum.STATIC.getType().equals(template.getType())) {
            importModel.appendLine("\u521d\u59cb\u5316\u9759\u6001\u6a21\u7248");
            TemplateEntity dbTemplate = this.staticTemplateService.initStaticTemplate(template, principal, false);
            importTemplate.setId(dbTemplate.getId());
        }
        importModel.appendLine("\u4fdd\u5b58\u6a21\u7248\u7684\u53ef\u89c1\u6027\u3001\u5e03\u5c40\u3001\u4e8b\u4ef6");
        this.handleEventScript(importTemplate, importModel);
        this.update(importTemplate);
        this.templateRepository.flush();
        importModel.appendLine("\u5bfc\u5165\u6a21\u7248\u660e\u7ec6\u9879\u7684excel\u6a21\u7248");
        this.templateItemExcelService.importData(template, templateItemExcels, importModel);
    }

    private void handleEventScript(TemplateEntity template, MigrateImportModel importModel) {
        Set events = template.getEvent();
        if (CollectionUtils.isEmpty((Collection)events)) {
            return;
        }
        ZipFile zipFile = importModel.getZipFile();
        for (TemplateEventEntity event : events) {
            try {
                byte[] bytes = ZipFileUtils.readZipFile((ZipFile)zipFile, (String)event.getRelativePath(), (String)event.getFileName());
                event.setJavascriptDesc(new String(bytes, StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(String.format("\u4ece\u538b\u7f29\u5305\u8bfb\u53d6\u6587\u4ef6\u51fa\u9519\uff1a%s/%s", event.getRelativePath(), event.getFileName()), e);
            }
        }
    }

    private TemplateEntity handleTemplateDataId(TemplateEntity template) {
        template.setId(null);
        this.handlePropertiesId(template.getProperties());
        this.handleEventId(template.getEvent());
        this.handleGroupId(template.getGroupRelations());
        this.handleRelationId(template.getRelations());
        this.handleVisibilityId(template.getVisibility());
        return template;
    }

    private TemplateEntity handleDynamicTemplate(TemplateEntity template) {
        this.removeIdProperty(template.getProperties());
        this.removeFormInstanceIdProperty(template.getProperties());
        Set<TemplateItemEntity> items = this.handleDynamicTemplateItem(template.getItemRelations());
        template.setItemRelations(items);
        Set groupRelations = template.getGroupRelations();
        if (!CollectionUtils.isEmpty((Collection)groupRelations)) {
            for (TemplateGroupEntity groupRelation : groupRelations) {
                Set<TemplateItemEntity> itemRelations = this.handleDynamicTemplateItem(groupRelation.getItemRelations());
                groupRelation.setItemRelations(itemRelations);
                this.removeIdProperty(groupRelation.getProperties());
                this.removeDynamicTemplateItemParentRelation(groupRelation.getParentTableName(), groupRelation.getRelations());
            }
        }
        return template;
    }

    private Set<TemplateItemEntity> handleDynamicTemplateItem(Set<TemplateItemEntity> itemRelations) {
        if (CollectionUtils.isEmpty(itemRelations)) {
            return itemRelations;
        }
        for (TemplateItemEntity itemRelation : itemRelations) {
            Set properties = itemRelation.getProperties();
            this.removeIdProperty(properties);
            this.removeDynamicTemplateItemParentRelation(itemRelation.getParentTableName(), itemRelation.getRelations());
        }
        return itemRelations;
    }

    private Set<TemplateRelationEntity> removeDynamicTemplateItemParentRelation(String parentTableName, Set<TemplateRelationEntity> relations) {
        if (CollectionUtils.isEmpty(relations)) {
            return relations;
        }
        Iterator<TemplateRelationEntity> iterator = relations.iterator();
        while (iterator.hasNext()) {
            TemplateRelationEntity relation = iterator.next();
            if (!relation.getTargetTableName().equals(parentTableName)) continue;
            iterator.remove();
        }
        return relations;
    }

    private Set<TemplatePropertyEntity> removeIdProperty(Set<TemplatePropertyEntity> properties) {
        if (CollectionUtils.isEmpty(properties)) {
            return properties;
        }
        Iterator<TemplatePropertyEntity> iterator = properties.iterator();
        while (iterator.hasNext()) {
            TemplatePropertyEntity property = iterator.next();
            if (!StringUtils.equals((CharSequence)property.getPropertyDbName(), (CharSequence)"id")) continue;
            iterator.remove();
        }
        return properties;
    }

    private Set<TemplatePropertyEntity> removeFormInstanceIdProperty(Set<TemplatePropertyEntity> properties) {
        if (CollectionUtils.isEmpty(properties)) {
            return properties;
        }
        Iterator<TemplatePropertyEntity> iterator = properties.iterator();
        while (iterator.hasNext()) {
            TemplatePropertyEntity property = iterator.next();
            if (!StringUtils.equals((CharSequence)property.getPropertyDbName(), (CharSequence)"form_instance_id")) continue;
            iterator.remove();
        }
        return properties;
    }

    private void handlePropertiesId(Set<TemplatePropertyEntity> properties) {
        if (CollectionUtils.isEmpty(properties)) {
            return;
        }
        properties.forEach(p -> p.setId(null));
    }

    private void handleVisibilityId(Set<TemplateVisibilityEntity> visibilities) {
        if (CollectionUtils.isEmpty(visibilities)) {
            return;
        }
        for (TemplateVisibilityEntity visibility : visibilities) {
            visibility.setId(null);
            if (!CollectionUtils.isEmpty((Collection)visibility.getAttributes())) {
                visibility.getAttributes().forEach(a -> a.setId(null));
            }
            if (CollectionUtils.isEmpty((Collection)visibility.getButtons())) continue;
            visibility.getButtons().forEach(b -> b.setId(null));
        }
    }

    private void handleRelationId(Set<TemplateRelationEntity> relations) {
        if (CollectionUtils.isEmpty(relations)) {
            return;
        }
        for (TemplateRelationEntity relation : relations) {
            relation.setId(null);
        }
    }

    private void handleGroupId(Set<TemplateGroupEntity> groupRelations) {
        if (CollectionUtils.isEmpty(groupRelations)) {
            return;
        }
        for (TemplateGroupEntity groupRelation : groupRelations) {
            groupRelation.setId(null);
            this.handlePropertiesId(groupRelation.getProperties());
            this.handleRelationId(groupRelation.getRelations());
            this.handleItemId(groupRelation.getItemRelations());
        }
    }

    private void handleItemId(Set<TemplateItemEntity> itemRelations) {
        if (CollectionUtils.isEmpty(itemRelations)) {
            return;
        }
        for (TemplateItemEntity itemRelation : itemRelations) {
            itemRelation.setId(null);
            this.handlePropertiesId(itemRelation.getProperties());
            this.handleRelationId(itemRelation.getRelations());
        }
    }

    private void handleEventId(Set<TemplateEventEntity> events) {
        if (CollectionUtils.isEmpty(events)) {
            return;
        }
        events.forEach(e -> e.setId(null));
    }

    private Set<TemplatePropertyEntity> sortedProperties(Set<TemplatePropertyEntity> properties) {
        LinkedHashSet currentProperties = null;
        if (properties != null) {
            currentProperties = new LinkedHashSet();
            currentProperties.addAll(properties.stream().sorted(Comparator.comparing(TemplatePropertyEntity::getIndex)).collect(Collectors.toList()));
        }
        return currentProperties;
    }

    private Set<TemplateRelationEntity> sortedRelations(Set<TemplateRelationEntity> relations) {
        LinkedHashSet currentRelations = null;
        if (relations != null) {
            currentRelations = new LinkedHashSet();
            currentRelations.addAll(relations.stream().sorted(Comparator.comparing(TemplateRelationEntity::getIndex)).collect(Collectors.toList()));
        }
        return currentRelations;
    }

    public Page<TemplateEntity> findByConditions(Map<String, Object> conditions, Pageable pageable) {
        if (pageable == null) {
            pageable = PageRequest.of((int)0, (int)50);
        }
        if (conditions == null) {
            conditions = new HashMap<String, Object>();
        }
        conditions.put("projectName", this.platformContext.getAppName());
        return this.templateRepository.findByConditions(pageable, conditions);
    }

    public int countByIds(String[] ids) {
        if (ids == null || ids.length == 0) {
            return 0;
        }
        return this.templateRepository.countByIds(ids);
    }

    @Transactional
    @CacheEvict(cacheNames={"template"}, allEntries=true)
    public TemplateEntity update(TemplateEntity template) {
        Validate.notNull((Object)template, (String)"\u9700\u8981\u4fdd\u5b58\u7684\u8868\u5355\u6a21\u677f\u4fe1\u606f\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        String templateId = template.getId();
        Validate.notBlank((CharSequence)templateId, (String)"\u8868\u5355\u6a21\u677f\u7f16\u53f7\u5fc5\u987b\u4f20\u5165!!", (Object[])new Object[0]);
        Optional op = this.templateRepository.findById(templateId);
        TemplateEntity currentTemplate = op.orElse(null);
        Validate.notNull((Object)currentTemplate, (String)"\u672a\u627e\u5230\u5f53\u524d\u6307\u5b9a\u7f16\u53f7\u5bf9\u5e94\u7684\u6a21\u677f\u4fe1\u606f!!", (Object[])new Object[0]);
        currentTemplate.setCode(template.getCode());
        currentTemplate.setCversion(template.getCversion());
        currentTemplate.setDomain(template.getDomain());
        currentTemplate.setFormStyle(template.getFormStyle());
        currentTemplate.setName(template.getName());
        currentTemplate.setType(template.getType());
        currentTemplate.setModifyTime(new Date());
        try {
            Object printTemplateLayout;
            Object templateLayout = template.getTemplateLayout();
            Validate.notNull((Object)templateLayout, (String)"\u9519\u8bef\u7684\u8868\u5355\u6a21\u677f\u5e03\u5c40\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            TemplateLayoutEntity currentLayout = this.templateLayoutService.save(templateId, 1, templateLayout);
            Validate.notNull((Object)currentLayout, (String)"\u9519\u8bef\u7684\u8868\u5355\u6a21\u677f\u5e03\u5c40\u4fdd\u5b58\u8fc7\u7a0b\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            Object mobileTemplateLayout = template.getMobileTemplateLayout();
            if (mobileTemplateLayout != null) {
                currentLayout = this.templateLayoutService.save(templateId, 2, mobileTemplateLayout);
                Validate.notNull((Object)currentLayout, (String)"\u9519\u8bef\u7684\u8868\u5355\u6a21\u677f\u5e03\u5c40\u4fdd\u5b58\u8fc7\u7a0b\uff08\u79fb\u52a8\u7aef\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            }
            if ((printTemplateLayout = template.getPrintTemplateLayout()) != null) {
                currentLayout = this.templateLayoutService.save(templateId, 3, printTemplateLayout);
                Validate.notNull((Object)currentLayout, (String)"\u9519\u8bef\u7684\u8868\u5355\u6a21\u677f\u5e03\u5c40\u4fdd\u5b58\u8fc7\u7a0b\uff08\u6253\u5370\u7aef\uff09\uff0c\u8bf7\u68c0\u67e5!!", (Object[])new Object[0]);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException(e);
        }
        Set templateEvents = template.getEvent();
        ArrayList<Object> events = CollectionUtils.isEmpty((Collection)templateEvents) ? new ArrayList<TemplateEventEntity>() : new ArrayList(templateEvents);
        this.templateEventService.save(templateId, events);
        Set templateVisibilities = template.getVisibility();
        if (templateVisibilities != null && !templateVisibilities.isEmpty()) {
            this.templateVisibilityService.save(currentTemplate, templateVisibilities);
        }
        return currentTemplate;
    }

    @Transactional
    @CacheEvict(cacheNames={"template"}, allEntries=true)
    public void updateDefaultVersion(String templateId) {
        Validate.notBlank((CharSequence)templateId, (String)"\u6307\u5b9a\u9ed8\u8ba4\u7248\u672c\u4fe1\u606f\u65f6,\u539f\u59cb\u6307\u5b9a\u7684templateId\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Optional op = this.templateRepository.findById(templateId);
        TemplateEntity currentTemplate = op.orElse(null);
        Validate.notNull((Object)currentTemplate, (String)VALIDATE_MESSAGE, (Object[])new Object[0]);
        Validate.notNull((Object)currentTemplate, (String)VALIDATE_MESSAGE, (Object[])new Object[0]);
        Validate.isTrue((currentTemplate.getTstatus() == 1 ? 1 : 0) != 0, (String)"\u5f53\u524d\u6307\u5b9a\u6a21\u677f\u7684\u72b6\u6001\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\uff08\u6a21\u677f\u72b6\u6001\u4e0d\u80fd\u4e3a\u7981\u7528\uff09!", (Object[])new Object[0]);
        this.templateRepository.updateDefaultVersion(currentTemplate.getCode());
        this.templateRepository.updateDefaultVersion(currentTemplate.getCode(), currentTemplate.getCversion(), new Date());
    }

    @Transactional
    @CacheEvict(cacheNames={"template"}, allEntries=true)
    public void updateStatusById(String templateId, Integer tstatus) {
        Validate.isTrue((tstatus == 1 || tstatus == 0 ? 1 : 0) != 0, (String)"\u6a21\u677f\u72b6\u6001\u53ea\u80fd\u8bbe\u5b9a\u4e3a1\uff08\u6b63\u5e38\uff09\u6216\u80050\uff08\u7981\u7528\uff09", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)templateId, (String)"\u6307\u5b9a\u9ed8\u8ba4\u7248\u672c\u4fe1\u606f\u65f6,\u539f\u59cb\u6307\u5b9a\u7684templateId\u5fc5\u987b\u4f20\u5165", (Object[])new Object[0]);
        Optional op = this.templateRepository.findById(templateId);
        TemplateEntity currentTemplate = op.orElse(null);
        Validate.notNull((Object)currentTemplate, (String)VALIDATE_MESSAGE, (Object[])new Object[0]);
        Validate.isTrue((currentTemplate.getDefaultVersion() != false && tstatus == 1 || currentTemplate.getDefaultVersion() == false ? 1 : 0) != 0, (String)"\u5f53\u524d\u6307\u5b9a\u7684\u6a21\u677f[%s]\u4e3a\u9ed8\u8ba4\u7248\u672c\uff0c\u5176\u72b6\u6001\u4e0d\u5141\u8bb8\u88ab\u7981\u7528.", (Object[])new Object[]{templateId});
        currentTemplate.setTstatus(tstatus);
        currentTemplate.setModifyTime(new Date());
        this.templateRepository.saveAndFlush(currentTemplate);
    }

    public JSONArray importTemplate(String templateEntityId) {
        Validate.notBlank((CharSequence)templateEntityId, (String)"\u5bfc\u5165\u6a21\u677fID\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        TemplateEntity template = this.findDetailsById(templateEntityId);
        Validate.notNull((Object)template, (String)"\u672a\u627e\u5230\u8be5\u6a21\u677f\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Set properties = template.getProperties();
        Set items = template.getItemRelations();
        Set groups = template.getGroupRelations();
        Set relations = template.getRelations();
        JSONArray json = new JSONArray();
        Integer index = 1;
        if (!CollectionUtils.isEmpty((Collection)properties)) {
            json.addAll((Collection)this.propertiesToJson(properties, null, index));
            index = index + properties.size();
        }
        if (!CollectionUtils.isEmpty((Collection)items)) {
            json.addAll((Collection)this.itemsToJson(items, null, index));
            index = index + items.size();
        }
        if (!CollectionUtils.isEmpty((Collection)relations)) {
            json.addAll((Collection)this.relationsToJson(relations, null, index));
            index = index + relations.size();
        }
        if (!CollectionUtils.isEmpty((Collection)groups)) {
            json.addAll((Collection)this.groupsToJson(groups, null, index));
        }
        return json;
    }

    private JSONArray propertiesToJson(Set<TemplatePropertyEntity> properties, String oldSort, Integer currentIndex) {
        JSONArray propertyArray = new JSONArray();
        for (TemplatePropertyEntity o : properties) {
            JSONObject propertyJson = new JSONObject();
            String place = StringUtils.isEmpty((CharSequence)oldSort) ? currentIndex.toString() : String.format(FORMAT_S, oldSort, currentIndex.toString());
            propertyJson.put(KEY, (Object)place);
            propertyJson.put(FIELD_NAME, (Object)o.getPropertyName());
            propertyJson.put(DESC, (Object)o.getPropertyDesc());
            propertyJson.put(NULLABLE, (Object)o.getNullable());
            propertyArray.add((Object)propertyJson);
            currentIndex = currentIndex + 1;
        }
        return propertyArray;
    }

    private JSONArray relationsToJson(Set<TemplateRelationEntity> relations, String oldSort, Integer currentIndex) {
        JSONArray relationArray = new JSONArray();
        for (TemplateRelationEntity o : relations) {
            JSONObject relationJson = new JSONObject();
            String place = StringUtils.isEmpty((CharSequence)oldSort) ? currentIndex.toString() : String.format(FORMAT_S, oldSort, currentIndex.toString());
            relationJson.put(KEY, (Object)place);
            relationJson.put(FIELD_NAME, (Object)o.getPropertyName());
            relationJson.put(DESC, (Object)o.getPropertyDesc());
            relationJson.put(NULLABLE, (Object)o.getNullable());
            relationArray.add((Object)relationJson);
            currentIndex = currentIndex + 1;
        }
        return relationArray;
    }

    private JSONArray itemsToJson(Set<TemplateItemEntity> items, String oldSort, Integer currentIndex) {
        JSONArray itemArray = new JSONArray();
        for (TemplateItemEntity o : items) {
            JSONObject itemJson = new JSONObject();
            String place = StringUtils.isEmpty((CharSequence)oldSort) ? currentIndex.toString() : String.format(FORMAT_S, oldSort, currentIndex.toString());
            itemJson.put(KEY, (Object)place);
            itemJson.put(FIELD_NAME, (Object)o.getPropertyName());
            itemJson.put(DESC, (Object)o.getPropertyDesc());
            itemJson.put(NULLABLE, (Object)true);
            itemJson.put(TYPE, (Object)OBJECT);
            itemJson.put("content", (Object)this.propertiesToJson(o.getProperties(), place, 1));
            itemArray.add((Object)itemJson);
        }
        return itemArray;
    }

    private JSONArray groupsToJson(Set<TemplateGroupEntity> groups, String oldSort, Integer currentIndex) {
        JSONArray groupArray = new JSONArray();
        for (TemplateGroupEntity o : groups) {
            JSONObject groupJson = new JSONObject();
            String place = StringUtils.isEmpty((CharSequence)oldSort) ? currentIndex.toString() : String.format(FORMAT_S, oldSort, currentIndex.toString());
            groupJson.put(KEY, (Object)place);
            groupJson.put(FIELD_NAME, (Object)o.getPropertyName());
            groupJson.put(DESC, (Object)o.getPropertyDesc());
            groupJson.put(NULLABLE, (Object)true);
            groupJson.put(TYPE, (Object)OBJECT_ARRAY);
            JSONArray groupContent = new JSONArray();
            Integer subIndex = 1;
            if (!CollectionUtils.isEmpty((Collection)o.getProperties())) {
                groupContent.addAll((Collection)this.propertiesToJson(o.getProperties(), place, subIndex));
            }
            subIndex = CollectionUtils.isEmpty((Collection)o.getProperties()) ? subIndex : subIndex + o.getProperties().size();
            if (!CollectionUtils.isEmpty((Collection)o.getRelations())) {
                groupContent.addAll((Collection)this.relationsToJson(o.getRelations(), place, subIndex));
            }
            subIndex = CollectionUtils.isEmpty((Collection)o.getRelations()) ? subIndex : subIndex + o.getRelations().size();
            if (!CollectionUtils.isEmpty((Collection)o.getItemRelations())) {
                groupContent.addAll((Collection)this.itemsToJson(o.getItemRelations(), place, subIndex));
            }
            groupJson.put("content", (Object)groupContent);
            groupArray.add((Object)groupJson);
        }
        return groupArray;
    }
}

