/*
 * Decompiled with CFR 0.152.
 */
package com.bizunited.platform.kuiper.starter.service.migrate.internal;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.service.NebulaToolkitService;
import com.bizunited.platform.common.util.ZipFileUtils;
import com.bizunited.platform.kuiper.entity.MigrateExportEntity;
import com.bizunited.platform.kuiper.entity.PageEntity;
import com.bizunited.platform.kuiper.entity.PageEventEntity;
import com.bizunited.platform.kuiper.entity.PageFlowEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateEventEntity;
import com.bizunited.platform.kuiper.entity.TemplateItemExcelEntity;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.common.enums.TemplateLayoutTypeEnum;
import com.bizunited.platform.kuiper.starter.repository.migrate.MigrateExportRepository;
import com.bizunited.platform.kuiper.starter.service.FrontFileSevice;
import com.bizunited.platform.kuiper.starter.service.ListTemplateService;
import com.bizunited.platform.kuiper.starter.service.PageFlowService;
import com.bizunited.platform.kuiper.starter.service.TemplateItemExcelService;
import com.bizunited.platform.kuiper.starter.service.TemplateLayoutService;
import com.bizunited.platform.kuiper.starter.service.migrate.MigrateExportService;
import com.bizunited.platform.rbac.server.util.SecurityUtils;
import com.bizunited.platform.user.common.service.user.UserService;
import com.bizunited.platform.user.common.vo.UserVo;
import com.bizunited.platform.venus.common.service.file.VenusFileService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipOutputStream;
import javax.transaction.Transactional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service(value="kuiperMigrateExportService")
public class MigrateExportServiceImpl
implements MigrateExportService {
    private static final Logger LOGGER = LoggerFactory.getLogger(MigrateExportServiceImpl.class);
    @Autowired
    private MigrateExportRepository migrateExportRepository;
    @Autowired
    private ApplicationContext applicationContext;
    @Autowired
    private UserService userService;
    @Autowired
    private PageFlowService pageFlowService;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private VenusFileService venusFileService;
    @Autowired
    private ListTemplateService listTemplateService;
    @Autowired
    private NebulaToolkitService nebulaToolkitService;
    @Autowired
    private TemplateLayoutService templateLayoutService;
    @Autowired
    private TemplateItemExcelService templateItemExcelService;
    @Autowired
    private FrontFileSevice frontFileSevice;
    @Autowired
    private PlatformContext platformContext;

    @Override
    @Transactional
    public MigrateExportEntity save(MigrateExportEntity export) {
        Validate.notNull((Object)export.getDataType(), (String)"\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        UserVo user = SecurityUtils.getCurrentUser();
        export.setCreateTime(new Date());
        export.setCreateUser(user);
        export.setCreator(user.getAccount());
        export.setProjectName(this.platformContext.getAppName());
        return (MigrateExportEntity)this.migrateExportRepository.save(export);
    }

    private MigrateExportEntity save(Integer dataType, String datas) {
        Validate.notNull((Object)dataType, (String)"\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
        MigrateExportEntity export = new MigrateExportEntity();
        export.setDataType(dataType);
        export.setDatas(datas);
        MigrateExportService migrateExportService = (MigrateExportService)this.applicationContext.getBean(MigrateExportService.class);
        return migrateExportService.save(export);
    }

    @Override
    public List<MigrateExportEntity> findDetailsByDataType(Integer dataType) {
        if (dataType == null) {
            return Lists.newArrayList();
        }
        List<MigrateExportEntity> exports = null;
        String projectName = this.platformContext.getAppName();
        exports = StringUtils.isNotBlank((CharSequence)projectName) ? this.migrateExportRepository.findByDataTypeAndProjectName(dataType, projectName) : this.migrateExportRepository.findByDataTypeAndBlankProjectName(dataType);
        if (CollectionUtils.isEmpty(exports)) {
            return Lists.newArrayList();
        }
        HashMap<String, UserVo> userCache = new HashMap<String, UserVo>();
        for (MigrateExportEntity export : exports) {
            String creator = export.getCreator();
            UserVo user = (UserVo)userCache.get(creator);
            if (user == null) {
                user = this.userService.findByAccount(creator);
                userCache.put(creator, user);
            }
            export.setCreateUser(user);
        }
        return exports;
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] exportListTempate(String[] ids) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] exportPageFlow(String[] ids) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] exportFormTemplate(String[] ids) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void writeTemplateFile(ZipOutputStream zos, List<TemplateEntity> exportTemplates, Map<String, List<TemplateItemExcelEntity>> templateItemExcel) throws IOException {
        for (TemplateEntity templateEntity : exportTemplates) {
            Set events = templateEntity.getEvent();
            if (CollectionUtils.isEmpty((Collection)events)) continue;
            for (TemplateEventEntity event : events) {
                this.writeFileToZip(zos, event.getRelativePath(), event.getFileName(), String.format("\u672a\u627e\u5230\u8868\u5355\u6a21\u7248\u7684\u4e8b\u4ef6\u5185\u5bb9\uff1a%s/%s", event.getRelativePath(), event.getFileName()));
            }
        }
        for (List list : templateItemExcel.values()) {
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            for (TemplateItemExcelEntity excel : list) {
                this.writeFileToZip(zos, excel.getFilePath(), excel.getFileName(), String.format("\u672a\u627e\u5230\u8868\u5355\u660e\u7ec6\u5bfc\u5165\u6a21\u7248\uff1a%s/%s", excel.getFilePath(), excel.getFileName()));
            }
        }
    }

    private Map<String, List<TemplateItemExcelEntity>> getTemplateItemExcel(List<TemplateEntity> exportTemplates) {
        HashMap<String, List<TemplateItemExcelEntity>> excelMap = new HashMap<String, List<TemplateItemExcelEntity>>();
        for (TemplateEntity template : exportTemplates) {
            List<TemplateItemExcelEntity> itemExcels = this.templateItemExcelService.findByTemplate(template.getId());
            String key = String.format("%s|%s", template.getCode(), template.getCversion());
            excelMap.put(key, itemExcels);
        }
        return excelMap;
    }

    private void loadFormTemplateLayout(List<TemplateEntity> exportTemplates) {
        for (TemplateEntity template : exportTemplates) {
            JSONObject pcLayout = this.templateLayoutService.findDetailsByTemplateId(template.getId(), TemplateLayoutTypeEnum.PC.getType());
            Validate.notNull((Object)pcLayout, (String)"\u672a\u627e\u5230\u8868\u5355\u6a21\u7248\u7684\u5e03\u5c40\u6587\u4ef6\uff1a\u6a21\u7248\u7f16\u53f7=%s, \u7248\u672c\u53f7=%s", (Object[])new Object[]{template.getCode(), template.getCversion()});
            JSONObject mobileLayout = this.templateLayoutService.findDetailsByTemplateId(template.getId(), TemplateLayoutTypeEnum.MOBILE.getType());
            JSONObject printLayout = this.templateLayoutService.findDetailsByTemplateId(template.getId(), TemplateLayoutTypeEnum.PRINT.getType());
            template.setTemplateLayout((Object)pcLayout);
            template.setMobileTemplateLayout((Object)mobileLayout);
            template.setPrintTemplateLayout((Object)printLayout);
        }
    }

    private void writePageFlowFile(ZipOutputStream zos, List<PageFlowEntity> pageFlows) throws IOException {
        for (PageFlowEntity pageFlow : pageFlows) {
            this.writeFileToZip(zos, pageFlow.getRelativePath(), pageFlow.getFileName(), String.format("\u672a\u627e\u5230\u9875\u9762\u6d41\u6587\u4ef6\uff1a%s", pageFlow.getCode()));
            Set pages = pageFlow.getPages();
            if (CollectionUtils.isEmpty((Collection)pages)) continue;
            for (PageEntity page : pages) {
                this.writeFileToZip(zos, page.getRelativePath(), page.getFileName(), String.format("\u672a\u627e\u5230\u9875\u9762\u6587\u4ef6\uff1a%s", page.getCode()));
                Set events = page.getEvents();
                if (CollectionUtils.isEmpty((Collection)events)) continue;
                for (PageEventEntity event : events) {
                    this.writeFileToZip(zos, event.getRelativePath(), event.getFileName(), String.format("\u672a\u627e\u5230\u4e8b\u4ef6\u6587\u4ef6\uff1a%s", event.getEventId()));
                }
            }
        }
    }

    private void writeFileToZip(ZipOutputStream zos, String relativePath, String fileName, String errorMsg) throws IOException {
        byte[] pageBytes = this.venusFileService.readFileContent(relativePath, fileName);
        Validate.isTrue((boolean)ArrayUtils.isNotEmpty((byte[])pageBytes), (String)"%s, {\u6587\u4ef6\u8def\u5f84\uff1a%s,\u6587\u4ef6\u540d:%s}", (Object[])new Object[]{errorMsg, relativePath, fileName});
        ZipFileUtils.writeZipFile((ZipOutputStream)zos, (String)relativePath, (String)fileName, (byte[])pageBytes);
    }

    /*
     * Exception decompiling
     */
    @Override
    public byte[] exportFrontFile(String[] frontFileIds) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

