package com.bizunited.platform.kuiper.starter.common.enums;

/**
 * 模板导入模板文件名称、编码枚举
 * @Author: chenrong
 * @Date: 2020/11/5 20:00
 */
public enum FormTemplateImportEnum {
  USER_TEMPLATE("用户", "com.bizunited.platform.user.common.vo.UserVo", "user_template.zip"),
  USER_GROUP_TEMPLATE("用户组", "com.bizunited.platform.user.common.vo.UserGroupVo", "user_group_template.zip"),
  ROLE_TEMPLATE("角色", "com.bizunited.platform.rbac.server.vo.RoleVo", "role_template.zip"),
  POSITION_TEMPLATE("职位", "com.bizunited.platform.user.common.vo.PositionLevelVo", "position_template.zip"),
  POSITION_LEVEL_TEMPLATE("职级", "com.bizunited.platform.user.common.vo.PositionLevelVo", "position_level_template.zip"),
  ORGANIZATION_TEMPLATE("组织", "com.bizunited.platform.user.common.vo.OrganizationVo", "organization_template.zip"),

  ;
  /** 描述 **/
  private String des;

  /** 表单编码 **/
  private String code;

  /** 表单导入文件名 **/
  private String fileName;

  FormTemplateImportEnum(String des, String code, String fileName) {
    this.des = des;
    this.code = code;
    this.fileName = fileName;
  }

  public String getCode() {
    return code;
  }

  public String getFileName() {
    return fileName;
  }

  public String getDes() {
    return des;
  }
}
