package com.bizunited.platform.kuiper.starter.common.enums;

/**
 * 列表导入模板文件名称、编码枚举
 *
 * @Author: chenrong
 * @Date: 2020/11/5 20:32
 */
public enum ListTemplateImportEnum {

  USER_LIST("用户列表", "user_manage", "user_list.zip", "user_import_template.xlsx", "user_manage-btnOprt-1604664772739", "用户导入模板.xlsx"),
  USER_GROUP_LIST("用户组列表", "user_group", "user_group_list.zip", "", "",""),
  POSITION_LIST("职位列表", "PosList", "position_list.zip", "position_import_template.xlsx", "PosList-btnOprt-1604543341345", "职位导入模板.xlsx"),
  POSITION_LEVEL_LIST("职级列表", "position_manage", "position_level_list.zip", "position_level_import_template.xlsx", "position_manage-btnOprt-1604287052272", "职级导入模板.xlsx"),
  AREA_LIST("行政区域列表", "administration_region", "area_list.zip", "area_import_template.xlsx", "administration_region-btnOprt-1604547370086", "行政区域导入模板.xlsx"),
  ROLE_LIST("角色列表", "RoleList", "role_list.zip", "role_import_template.xlsx", "RoleList-btnOprt-1604305684430", "角色导入模板.xlsx"),
  ORGANIZATION_LIST("组织列表", "org-management", "organization_list.zip", "organization_import_template.xlsx", "org-management-btnOprt-1604460314236", "组织导入模板.xlsx"),

  UNBIND_ANY_POSITION_LIST("未关联任何角色职位", "unbind_any_position", "unbind_any_position_list.zip", "", "", ""),
  REPLACE_ROLE_LIST("替换关联角色列表", "replace-role", "replace_role_list.zip", "", "", ""),
  FIND_BIND_POSITION_LIST("已关联该角色的职位", "find_bind_position", "find_bind_position_list.zip", "", "", ""),
  FIND_UNBIND_POSITION_LIST("未关联当前角色的职位", "find_unbind_position", "find_unbind_position_list.zip", "", "", ""),
  REGION_IN_LIST("组织/行政区域挂靠", "RegionIn", "RegionIn.zip", "", "", ""),

  ;

  /** 描述 **/
  private String desc;

  /** 列表编码 **/
  private String code;

  /** 列表导入文件名 **/
  private String fileName;

  /** 列表导入excel模板名 **/
  private String excelName;

  /** 列表导入按钮编码 **/
  private String importBtnCode;

  /** excel下载名称 **/
  private String excelViewName;

  ListTemplateImportEnum(String desc, String code, String fileName, String excelName, String importBtnCode, String excelViewName) {
    this.desc = desc;
    this.code = code;
    this.fileName = fileName;
    this.excelName = excelName;
    this.importBtnCode = importBtnCode;
    this.excelViewName = excelViewName;
  }

  public String getDesc() {
    return desc;
  }

  public String getCode() {
    return code;
  }

  public String getFileName() {
    return fileName;
  }

  public String getExcelName() {
    return excelName;
  }

  public String getImportBtnCode() {
    return importBtnCode;
  }

  public String getExcelViewName() {
    return excelViewName;
  }
}
