package com.bizunited.platform.kuiper.starter.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.service.DynamicInstanceService;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;

@RestController
@RequestMapping("/v1/kuiper/dynamicInstatnces")
public class DynamicInstanceController extends BaseController {
  private static final Logger LOGGER = LoggerFactory.getLogger(DynamicInstanceController.class);
  @Autowired
  private DynamicInstanceService dynamicInstanceService;

  @ApiOperation("获取实例基本信息，不对任何关联信息进行查询")
  @ApiImplicitParams({@ApiImplicitParam(name = "formInstanceId", value = "指定的实例id", required = true)})
  @GetMapping("/findByFormInstanceId")
  public ResponseModel findByFormInstanceId(@RequestParam("formInstanceId") String formInstanceId) {
    try {
      JSONObject json = dynamicInstanceService.findByFormInstanceId(formInstanceId);
      return this.buildHttpResultW(json, StringUtils.EMPTY);
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  @ApiOperation(" 根据实例ID信息，获取实例的详情，包含所有可能的关联信息")
  @ApiImplicitParams({@ApiImplicitParam(name = "formInstanceId", value = "指定的实例id", required = true)})
  @GetMapping("/findDetailsByFormInstanceId")
  public ResponseModel findDetailsByFormInstanceId(@RequestParam("formInstanceId") String formInstanceId) {
    try {
      JSONObject json = dynamicInstanceService.findDetailsByFormInstanceId(formInstanceId);
      return this.buildHttpResultW(json, StringUtils.EMPTY);
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  @ApiOperation("保存或修改表单模板信息业务数据，至少需要拆分传入的json属性：表单实例id(formInstanceId)、实例活动id（instanceActivityId）,其它json信息按照数据要求传入")
  @RequestMapping(value = "", method = {RequestMethod.POST , RequestMethod.PATCH})
  public ResponseModel save(@RequestBody @ApiParam(name = "inputData", value = "表单模板业务数据信息") JSONObject inputData, HttpServletRequest request) {
    try {
      // 开始调用
      JSONObject data = JSONObject.parseObject(JSON.toJSONString(inputData.get("jsonData")));
      JSONObject invokeParamsObj = inputData.getJSONObject("invokeParams");
      Validate.notNull(invokeParamsObj, "参数不能为空");
      data.put("instanceActivityId", invokeParamsObj.getString("instanceActivityId"));
      if (StringUtils.equalsIgnoreCase(request.getMethod(), RequestMethod.POST.name())) {
        this.dynamicInstanceService.create(data);
      } else if (StringUtils.equalsIgnoreCase(request.getMethod(), RequestMethod.PATCH.name())) {
        this.dynamicInstanceService.update(data);
      }
      return this.buildHttpResult();
    } catch (Exception e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }
}