package com.bizunited.platform.kuiper.starter.model;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplatePropertyEntity;
import com.bizunited.platform.kuiper.entity.TemplateRelationEntity;
import com.bizunited.platform.saturn.model.PersistentClass;
import com.bizunited.platform.saturn.model.PersistentProperty;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.springframework.util.CollectionUtils;

import java.util.Map;
import java.util.Set;

/**
 * 静态表单模板合并model
 * 主要用于：
 * 1.请求传参
 * 2.上下文数据记录和反复复用
 */
public class StaticTemplateMergeModel {
  /** 传参：基准表单模板id*/
  private String referenceTemplateId;
  /** 传参：待合并表单模板id*/
  private String mergedTemplateId;
  /** 传参：新合并的表单模板名称*/
  private String newTemplateName;
  /** 传参：新合并的表单模板版本号*/
  private String newTemplateVersion;
  /** 传参：操作人账号*/
  private String account;

  /** 基准表单模板数据*/
  private TemplateEntity referenceTemplate;
  /** 待合并表单模板数据*/
  private TemplateEntity mergedTemplate;
  /** 新合并的表单模板数据*/
  private TemplateEntity newTemplate;

  /** 当前表单模型或关联模型等的数据结构描述信息*/
  private PersistentClass currentPersistentClass;

  /** 记录基准表单模型的一般属性数据结构描述信息map*/
  private Map<String, TemplatePropertyEntity> refMap;

  /** 记录待合并表单模型的一般属性数据结构描述信息map*/
  private Map<String,TemplatePropertyEntity> mergedMap;

  /** 记录基准表单模型的关联属性数据结构描述信息map*/
  private Map<String, TemplateRelationEntity> refRelationMap;

  /** 记录待合并表单模型的关联属性数据结构描述信息map*/
  private Map<String,TemplateRelationEntity> mergedRelationMap;

  /** 记录基准表单模型的一般属性数据结构描述信息map*/
  private Map<String, PersistentProperty> persistentPropertyMap;

  /** 可以反复复用的交集*/
  private Set<String> intersections;

  /** 可以反复复用的正向差集*/
  private Set<String> refMergedDiff;

  /** 可以反复复用的反向差集*/
  private Set<String> mergedRefDiff;

  /** 记录的合并信息，主要记录合并的属性名称和什么操作，比如：x字段是新增，y字段是更新*/
  private JSONObject mergeInfo = new JSONObject();

  /** 记录前端基准布局json文件的解析信息*/
  private JSONObject refJsonResolveInfo = new JSONObject();

  /** 记录前端待合并布局json文件的解析信息*/
  private JSONObject mergedJsonResolveInfo = new JSONObject();

  /** 记录前端基准布局json文件中label的解析信息*/
  private JSONObject refLabelJsonInfo = new JSONObject();

  /** 记录前端待合并布局json文件中label的解析信息*/
  private JSONObject mergedLabelJsonInfo = new JSONObject();

  /** 记录前端基准布局json文件中field的解析信息*/
  private JSONObject refFieldJsonInfo = new JSONObject();

  /** 记录前端待合并布局json文件中field的解析信息*/
  private JSONObject mergedFieldJsonInfo = new JSONObject();



  public void setMaps(Map<String, TemplatePropertyEntity> refMap,Map<String,TemplatePropertyEntity> mergedMap,Map<String, PersistentProperty> persistentPropertyMap){
    this.clearMaps();
    this.setRefMap(refMap);
    this.setMergedMap(mergedMap);
    this.setPersistentPropertyMap(persistentPropertyMap);
  }

  public void clearMaps(){
    if(!CollectionUtils.isEmpty(refMap)){
      refMap = Maps.newHashMap();
    }
    if(!CollectionUtils.isEmpty(mergedMap)){
      mergedMap = Maps.newHashMap();
    }
    if(!CollectionUtils.isEmpty(persistentPropertyMap)){
      persistentPropertyMap = Maps.newHashMap();
    }
    if(!CollectionUtils.isEmpty(refRelationMap)){
      refRelationMap = Maps.newHashMap();
    }
    if(!CollectionUtils.isEmpty(mergedRelationMap)){
      mergedRelationMap = Maps.newHashMap();
    }
  }

  public void setSets(Set<String> intersections,Set<String> refMergedDiff,Set<String> mergedRefDiff){
    this.clearSets();
    this.setIntersections(intersections);
    this.setRefMergedDiff(refMergedDiff);
    this.setMergedRefDiff(mergedRefDiff);
  }

  public void clearSets(){
    if(!CollectionUtils.isEmpty(intersections)){
      intersections = Sets.newHashSet();
    }
    if(!CollectionUtils.isEmpty(refMergedDiff)){
      refMergedDiff = Sets.newHashSet();
    }
    if(!CollectionUtils.isEmpty(mergedRefDiff)){
      mergedRefDiff = Sets.newHashSet();
    }
  }

  public Set<String> getIntersections() {
    return intersections;
  }

  public void setIntersections(Set<String> intersections) {
    this.intersections = intersections;
  }

  public Set<String> getRefMergedDiff() {
    return refMergedDiff;
  }

  public void setRefMergedDiff(Set<String> refMergedDiff) {
    this.refMergedDiff = refMergedDiff;
  }

  public Set<String> getMergedRefDiff() {
    return mergedRefDiff;
  }

  public void setMergedRefDiff(Set<String> mergedRefDiff) {
    this.mergedRefDiff = mergedRefDiff;
  }

  public TemplateEntity getNewTemplate() {
    return newTemplate;
  }

  public void setNewTemplate(TemplateEntity newTemplate) {
    this.newTemplate = newTemplate;
  }

  public TemplateEntity getReferenceTemplate() {
    return referenceTemplate;
  }

  public void setReferenceTemplate(TemplateEntity referenceTemplate) {
    this.referenceTemplate = referenceTemplate;
  }

  public TemplateEntity getMergedTemplate() {
    return mergedTemplate;
  }

  public void setMergedTemplate(TemplateEntity mergedTemplate) {
    this.mergedTemplate = mergedTemplate;
  }

  public PersistentClass getCurrentPersistentClass() {
    return currentPersistentClass;
  }

  public void setCurrentPersistentClass(PersistentClass currentPersistentClass) {
    this.currentPersistentClass = currentPersistentClass;
  }

  public String getReferenceTemplateId() {
    return referenceTemplateId;
  }

  public void setReferenceTemplateId(String referenceTemplateId) {
    this.referenceTemplateId = referenceTemplateId;
  }

  public String getMergedTemplateId() {
    return mergedTemplateId;
  }

  public void setMergedTemplateId(String mergedTemplateId) {
    this.mergedTemplateId = mergedTemplateId;
  }

  public String getNewTemplateName() {
    return newTemplateName;
  }

  public void setNewTemplateName(String newTemplateName) {
    this.newTemplateName = newTemplateName;
  }

  public String getNewTemplateVersion() {
    return newTemplateVersion;
  }

  public void setNewTemplateVersion(String newTemplateVersion) {
    this.newTemplateVersion = newTemplateVersion;
  }

  public String getAccount() {
    return account;
  }

  public void setAccount(String account) {
    this.account = account;
  }

  public Map<String, TemplatePropertyEntity> getRefMap() {
    return refMap;
  }

  public void setRefMap(Map<String, TemplatePropertyEntity> refMap) {
    this.refMap = refMap;
  }

  public Map<String, TemplatePropertyEntity> getMergedMap() {
    return mergedMap;
  }

  public void setMergedMap(Map<String, TemplatePropertyEntity> mergedMap) {
    this.mergedMap = mergedMap;
  }

  public Map<String, PersistentProperty> getPersistentPropertyMap() {
    return persistentPropertyMap;
  }

  public void setPersistentPropertyMap(Map<String, PersistentProperty> persistentPropertyMap) {
    this.persistentPropertyMap = persistentPropertyMap;
  }

  public Map<String, TemplateRelationEntity> getRefRelationMap() {
    return refRelationMap;
  }

  public void setRefRelationMap(Map<String, TemplateRelationEntity> refRelationMap) {
    this.refRelationMap = refRelationMap;
  }

  public Map<String, TemplateRelationEntity> getMergedRelationMap() {
    return mergedRelationMap;
  }

  public void setMergedRelationMap(Map<String, TemplateRelationEntity> mergedRelationMap) {
    this.mergedRelationMap = mergedRelationMap;
  }

  public JSONObject getMergeInfo() {
    return mergeInfo;
  }

  public void setMergeInfo(JSONObject mergeInfo) {
    this.mergeInfo = mergeInfo;
  }

  public JSONObject getRefJsonResolveInfo() {
    return refJsonResolveInfo;
  }

  public void setRefJsonResolveInfo(JSONObject refJsonResolveInfo) {
    this.refJsonResolveInfo = refJsonResolveInfo;
  }

  public JSONObject getMergedJsonResolveInfo() {
    return mergedJsonResolveInfo;
  }

  public void setMergedJsonResolveInfo(JSONObject mergedJsonResolveInfo) {
    this.mergedJsonResolveInfo = mergedJsonResolveInfo;
  }

  public JSONObject getRefLabelJsonInfo() {
    return refLabelJsonInfo;
  }

  public void setRefLabelJsonInfo(JSONObject refLabelJsonInfo) {
    this.refLabelJsonInfo = refLabelJsonInfo;
  }

  public JSONObject getMergedLabelJsonInfo() {
    return mergedLabelJsonInfo;
  }

  public void setMergedLabelJsonInfo(JSONObject mergedLabelJsonInfo) {
    this.mergedLabelJsonInfo = mergedLabelJsonInfo;
  }

  public JSONObject getRefFieldJsonInfo() {
    return refFieldJsonInfo;
  }

  public void setRefFieldJsonInfo(JSONObject refFieldJsonInfo) {
    this.refFieldJsonInfo = refFieldJsonInfo;
  }

  public JSONObject getMergedFieldJsonInfo() {
    return mergedFieldJsonInfo;
  }

  public void setMergedFieldJsonInfo(JSONObject mergedFieldJsonInfo) {
    this.mergedFieldJsonInfo = mergedFieldJsonInfo;
  }
}
