package com.bizunited.platform.kuiper.starter.repository;

import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Repository;
import com.alibaba.fastjson.JSONArray;
import com.bizunited.platform.kuiper.entity.TemplatePropertyEntity;

@Repository("DynamicInstanceCustomRepository")
public interface DynamicInstanceCustomRepository {
  /**
   * 基准的执行查询sql
   * @param sql
   * @return
   */
  public JSONArray execute(String sql);
  
  /**
   * 执行ManyToOne关系的查询逻辑
   * @param parentTableName 当前ManyToOne关系的上层表名，主表、明细、分组都有可能
   * @param targetTableName 当前表
   * @param parentPropertyDbName 当前ManyToOne关系上层表的关联字段
   * @param parentId 当前ManyToOne关系上层的关联id，主表id、分组id、明细id都有可能
   * @return
   */
  public JSONArray findManyToOne(String parentTableName , String targetTableName , String parentPropertyDbName , String parentId);
  /**
   * 执行ManyToMany关系的查询逻辑
   * @param parentTableName 当前ManyToMany关系的上层表名，主表、明细、分组都有可能
   * @param targetTableName 当前表
   * @param parentId 当前ManyToMany关系上层的关联id，主表id、分组id、明细id都有可能
   * @return
   */
  public JSONArray findManyToMany(String parentTableName , String targetTableName , String parentId);

  /**
   * 执行主表的一般属性的查询逻辑
   * @param properties
   * @param mainTableName 主表
   * @param formInstanceId 实例ID
   * @return
   */
  public JSONArray findProperties(Set<TemplatePropertyEntity> properties, String mainTableName, String formInstanceId);
  /**
   * 执行分组或明细下的一般属性的查询逻辑
   * @param properties
   * @param targetTableName 一般指分组或明细表
   * @param parentTableName 一般指主表或分组
   * @param parentId 一般指主表id或分组id
   * @param targetPropertyDesc 当前属性描述信息
   * @return
   */
  public JSONArray findProperties(Set<TemplatePropertyEntity> properties, String targetTableName, String parentTableName , String parentId, String targetPropertyDesc);

  /**
   * 执行新增、更新、删除语句
   * @param pattern
   * @param prams
   */
  public void executeNativeSQL(String pattern , Object... prams);
  /**
   * 执行查询语句
   * @param pattern
   * @param params
   */
  public List<?> executeQuerySql(String pattern , Object... params);
}
