package com.bizunited.platform.kuiper.starter.repository;

import com.bizunited.platform.kuiper.entity.InstanceEntity;
import com.bizunited.platform.kuiper.starter.repository.internal.InstanceRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * @author yinwenjie
 */
@Repository("InstanceRepository")
public interface InstanceRepository
    extends
    JpaRepository<InstanceEntity, String>,
    JpaSpecificationExecutor<InstanceEntity>,
    InstanceRepositoryCustom {
  
  /**
   * 按照实例编号查询实例详情，包括实例基本信息和对应的关联信息
   * @param instanceId 实例信息
   */
  @Query("from InstanceEntity ins "
      + " left join fetch ins.template tep "
      + " left join fetch ins.activities act "
      + " where ins.id = :instanceId ")
  public InstanceEntity findDetailsById(@Param("instanceId") String instanceId);

  /**
   * 根据指定的表单模板编号信息，查询这个表单模板下涉及的表单实例数量(多个模板id)
   * @param templateIds 指定的表单模板编号信息(支持多个模板id)
   * @return
   */
  @Query("select count(*) from InstanceEntity ins where ins.template.id in (:templateIds) ")
  public int countByTemplateIds(@Param("templateIds") String[] templateIds);
  
  /**
   * 根据指定的表单模板编号信息，查询这个表单模板下涉及的表单实例数量
   * @param templateId 指定的表单模板编号信息
   * @param projectName
   * @return
   */
  @Query("select count(*) from InstanceEntity ins where ins.template.id = :templateId ")
  public int countByTemplateId(@Param("templateId") String templateId);

  /**
   * 根据模版code查询实例
   * @param templateCode
   * @return
   */
  @Query("select i from InstanceEntity i inner join i.template t where t.code = :templateCode ")
  Set<InstanceEntity> findByTemplateCode(@Param("templateCode") String templateCode);

}
