package com.bizunited.platform.kuiper.starter.repository;

import com.bizunited.platform.kuiper.entity.TemplateEventEntity;

import java.util.List;
import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface TemplateEventRepository
    extends
      JpaRepository<TemplateEventEntity, String>,
      JpaSpecificationExecutor<TemplateEventEntity> {

  /**
   * 根据控件事件id , 查询事件本身的部分详情数据
   * @param id
   * @return
   */
  @Query(value = "select a from TemplateEventEntity a left join fetch a.template b where a.id = ?1")
  TemplateEventEntity findDetailById(String id);


  /**
   * 根据传入的templateId、controllerId、eventId 判断当前事件是否在该表单中唯一
   * @param templateId
   * @param controllerId
   * @param eventId
   * @return
   */
  @Query(value = "select count(*) from engine_form_event a where a.controller_id = :controllerId and a.template_id = :templateId and a.event_id = :eventId ", nativeQuery = true)
  int countByTemplateIdAndEventIdAndControllerId(@Param("templateId") String templateId, @Param("controllerId") String controllerId, @Param("eventId") String eventId);

  /**
   * 检查模板id是否存在且是否唯一 count=1 存在且唯一 count=0 不存在 count>1 存在但不唯一
   * @param templateId
   * @return
   */
  @Query(value = "select count(*) from engine_form_template where id = :templateId ", nativeQuery = true)
  int countByTemplateId(@Param("templateId") String templateId);

  /**
   * 按照指定的模板编号，删除模板下所有的模板事件信息
   * @param templateId 指定的模板信息
   */
  @Modifying
  @Query(value="delete from engine_form_event where engine_form_event.template_id = :templateId ", nativeQuery=true)
  public void deleteByTemplateId(@Param("templateId") String templateId);

  /**
   * 根据模板id查询事件数据(不带fetch)
   * @param templateId
   * @return
   */
  @Query(value = "select a from TemplateEventEntity a where a.template.id = :templateId ")
  List<TemplateEventEntity> findByTemplateId(@Param("templateId") String templateId);


  /**
   * 根据指定模板id,查询所有事件详情信息
   * @param templateId
   * @return
   */
  @Query(value = "select a from TemplateEventEntity a left join fetch a.template b where a.template.id = :templateId ")
  Set<TemplateEventEntity> findDetailsByTemplateId(@Param("templateId") String templateId);

  /**
   * 根据指定模板ids,查询所有事件详情信息
   * @param templateIds
   * @return
   */
  @Query(value = "select a from TemplateEventEntity a left join fetch a.template b where a.template.id in (:templateIds) ")
  Set<TemplateEventEntity> findDetailsByTemplateIds(@Param("templateIds") Set<String> templateIds);
}
