package com.bizunited.platform.kuiper.starter.repository;

import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.kuiper.entity.TemplateGroupEntity;

@Repository
public interface TemplateGroupRepository
    extends
      JpaRepository<TemplateGroupEntity, String>,
      JpaSpecificationExecutor<TemplateGroupEntity> {
  
  /**
   * 按照分组信息所属的上级模板，查询分组信息明细，包括分组下的一般属性、关联属性和可能的明细编辑属性
   * @param templateId
   * @return
   */
  @Query(value="select distinct groups from TemplateGroupEntity groups "
      + " left join fetch groups.properties p "
      + " left join fetch groups.relations r "
      + " left join fetch groups.itemRelations items "
      + " left join fetch items.properties ip "
      + " left join fetch items.relations ir "
      + " where groups.parentTemplate.id = :templateId ")
  public Set<TemplateGroupEntity> findDetailsByParentTemplate(@Param("templateId") String templateId);

  /**
   * 按照分组信息所属的上级模板，查询分组信息明细，包括分组下的一般属性、关联属性和可能的明细编辑属性
   * @param templateIds
   * @return
   */
  @Query(value="select distinct groups from TemplateGroupEntity groups "
          + " left join fetch groups.properties p "
          + " left join fetch groups.relations r "
          + " left join fetch groups.itemRelations items "
          + " left join fetch items.properties ip "
          + " left join fetch items.relations ir "
          + " where groups.parentTemplate.id in (:templateIds) ")
  public Set<TemplateGroupEntity> findDetailsByParentTemplates(@Param("templateIds") Set<String> templateIds);

  /**
   * 查询包含父级详情
   * @param id
   * @return
   */
  @Query(value = "select distinct groups from TemplateGroupEntity groups "
      + " left join fetch groups.parentTemplate pt "
      + " where groups.id = :id ")
  TemplateGroupEntity findParentById(@Param("id")String id);

}
