package com.bizunited.platform.kuiper.starter.repository;

import com.bizunited.platform.kuiper.entity.TemplateItemExcelEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * TemplateItemExcelRepository
 *
 * @description: 模板明细项上传EXCEL关联信息
 * @author: yanwe
 * @date: 19/Aug/2019 16:05
 */
@Repository
public interface TemplateItemExcelRepository extends JpaRepository<TemplateItemExcelEntity, String>, JpaSpecificationExecutor<TemplateItemExcelEntity> {

  /**
   * 查询主模板下所有明细EXCEL关联信息
   * @param tempalteId
   * @return
   */
  List<TemplateItemExcelEntity> findByTemplateId(String tempalteId);

  /**
   * 查询分组模板下所有明细EXCEL关联信息
   * @param templateGroupId
   * @return
   */
  List<TemplateItemExcelEntity> findByTemplateGroupId(String templateGroupId);


  /**
   * 查询模板明细下唯一的EXCEL关联信息
   * @param templateItemId
   * @return
   */
  TemplateItemExcelEntity findByTemplateItemId(String templateItemId);
  



}
