package com.bizunited.platform.kuiper.starter.repository;

import com.bizunited.platform.kuiper.entity.TemplateLayoutEntity;

import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface TemplateLayoutRepository
    extends
      JpaRepository<TemplateLayoutEntity, String>,
      JpaSpecificationExecutor<TemplateLayoutEntity> {
  /**
   * 查询指定模板id的基本布局信息（可能有多个），并不包括布局内容
   * @param templateId 模板编号
   * @return
   */
  @Query(value = "select tle from TemplateLayoutEntity tle "
      + " left join fetch tle.template t where t.id = :templateId ")
  public Set<TemplateLayoutEntity> findByTemplateId(@Param("templateId") String templateId);
  /**
   * 查询指定模板ids的基本布局信息（可能有多个），并不包括布局内容
   * @param templateIds 模板编号
   * @return
   */
  @Query(value = "select tle from TemplateLayoutEntity tle "
          + " left join fetch tle.template t where t.id in (:templateIds) ")
  public Set<TemplateLayoutEntity> findByTemplateIds(@Param("templateIds") Set<String> templateIds);
  /**
   * 查询指定模板下，指定布局类型的基本信息，并不包括布局内容
   * @param templateId 模板编号
   * @param type 布局类型：1.PC端；2.mobile端；3.print端
   * @return
   */
  @Query(value = "select tle from TemplateLayoutEntity tle "
      + " left join fetch tle.template t where t.id = :templateId and tle.layoutType = :layoutType ")
  public TemplateLayoutEntity findByTemplateIdAndType(@Param("templateId") String templateId , @Param("layoutType") Integer layoutType);
  /**
   * 按照指定的模板编号，删除其下布局信息
   * @param templateId 指定的模板编号信息
   */
  @Modifying
  @Query(value = "delete from engine_form_layout where engine_form_layout.template_id = :templateId ", nativeQuery = true)
  public void deleteByTemplateId(@Param("templateId") String templateId);
}
