package com.bizunited.platform.kuiper.starter.repository;

import com.bizunited.platform.kuiper.entity.TemplateMaintainerEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

/**
 * 表单引擎模版的维护人员持久层接口定义
 * @Author: Paul Chan
 * @Date: 2020-05-25 17:11
 */
@Repository("TemplateMaintainerRepository")
public interface TemplateMaintainerRepository extends JpaRepository<TemplateMaintainerEntity, String>, JpaSpecificationExecutor<TemplateMaintainerEntity> {

  /**
   * 根据模板id，查询维护人员的id集
   *
   * @param templateId
   * @return
   */
  @Query("select tm from TemplateMaintainerEntity tm " +
      " inner join tm.template t" +
      " where t.id = :templateId  order by tm.createTime")
  public Set<TemplateMaintainerEntity> findByTemplateId(@Param("templateId") String templateId);

  /**
   * 解除模版的维护人员
   * @param templateId
   */
  @Modifying
  @Query(value = "delete from engine_form_template_maintainer where template_id = :templateId ", nativeQuery = true)
  void unbindByTemplateId(@Param("templateId") String templateId);
}
