package com.bizunited.platform.kuiper.starter.repository;

import java.util.Set;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.kuiper.entity.TemplatePropertyEntity;

@Repository("MainModelPropertyRepository")
public interface TemplatePropertyRepository
    extends
      JpaRepository<TemplatePropertyEntity, String>,
      JpaSpecificationExecutor<TemplatePropertyEntity> {
  /**
   * 按照当前指定的明细信息，查询明细下的一般属性描述
   * @param currentItemId
   * @return
   */
  @Query("from TemplatePropertyEntity p left join fetch p.currentItem c where c.id = :currentItemId ")
  Set<TemplatePropertyEntity> findByCurrentItem(@Param("currentItemId") String currentItemId);
  
  /**
   * 按照当前指定的分组信息，查询分组下的一般属性描述
   * @param currentGroupId
   * @return
   */
  @Query("from TemplatePropertyEntity p left join fetch p.currentGroup c where c.id = :currentGroupId ")
  Set<TemplatePropertyEntity> findByCurrentGroup(@Param("currentGroupId") String currentGroupId);
  
  /**
   * 按照当前指定的主模型信息，查询主模型下的一般属性描述
   * @param currentTemplateId
   * @return
   */
  @Query("from TemplatePropertyEntity p left join fetch p.currentTemplate c where c.id = :currentTemplateId ")
  Set<TemplatePropertyEntity> findByCrrentTemplate(@Param("currentTemplateId") String currentTemplateId);
}
