package com.bizunited.platform.kuiper.starter.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.kuiper.entity.TemplateVisibilityAttributesEntity;

import java.util.Set;

@Repository("TemplateVisibilityAttributesRepository")
public interface TemplateVisibilityAttributesRepository extends JpaRepository<TemplateVisibilityAttributesEntity, String>, JpaSpecificationExecutor<TemplateVisibilityAttributesEntity> {
  /**
   * 根据表单可见性id查询属性信息
   * @param visibilityId 表单可见性id
   * @return
   */
  @Query(value = "select eva from TemplateVisibilityAttributesEntity eva "
   + "LEFT join fetch eva.templateVisibility tv where tv.id = :visibilityId")
  Set<TemplateVisibilityAttributesEntity> findByVisiblId(@Param("visibilityId") String visibilityId);

  @Query(value = "select count(*) from engine_form_visibility_attributes eva where eva.visibility_id = :visibilityId and eva.controller_id = :controllerId ", nativeQuery = true)
  int countAttController(@Param("visibilityId") String visibilityId, @Param("controllerId") String controllerId);
  
  
  /**
   * 按照可见性编号，删除其下所有可见性元素信息
   * @param templateVisibilityId 
   */
  @Modifying
  @Query(value="delete from engine_form_visibility_attributes where engine_form_visibility_attributes.visibility_id = :templateVisibilityId  " , nativeQuery=true)
  public void deleteByTemplateVisibilityId(@Param("templateVisibilityId") String templateVisibilityId);

  /**
   * 根据可见性ID和布局查询属性
   * @param visibilityId
   * @param layoutType
   * @return
   */
  @Query("select va from TemplateVisibilityAttributesEntity va inner join va.templateVisibility v" +
      " where v.id = :visibilityId and va.layoutType = :layoutType ")
  Set<TemplateVisibilityAttributesEntity> findByVisibilityIdAndLayoutType(@Param("visibilityId") String visibilityId, @Param("layoutType") Integer layoutType);
}
