package com.bizunited.platform.kuiper.starter.repository.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.kuiper.entity.FrontFileEntity;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

@Repository("FrontFileRepositoryImpl")
public class FrontFileRepositoryImpl implements FrontFileRepositoryCustom {

  @Autowired @PersistenceContext 
  private EntityManager entityManager;
  @Autowired
  private PlatformContext platformContext;
  private static final String FILE_CLASSIFY = "fileClassify";
  private static final String FILE_STATUS = "fileStatus";

  @SuppressWarnings("unchecked")
  @Override
  public Page<FrontFileEntity> queryPage(Pageable pageable, Map<String, Object> conditions) {
    // 目前支持前端文件名称，分类，文件状态进行查询
    String hql = "from FrontFileEntity front where 1=1 ";
    String countSql = "select count(*) from FrontFileEntity front where 1=1 ";
    //筛选项目名称
    hql += " and front.projectName=:projectName ";
    countSql += " and front.projectName=:projectName ";
    // name
    Object name = conditions.get("name");
    if (name != null) {
      hql += " AND front.name = :name ";
      countSql += " AND front.name = :name ";
    }
    // fileStatus
    Object fileClassify = conditions.get(FILE_CLASSIFY);
    if (fileClassify != null) {
      hql += " AND front.fileClassify = :fileClassify ";
      countSql += " AND front.fileClassify = :fileClassify ";
    }

    // 文件状态
    Object fileStatus = conditions.get(FILE_STATUS);
    if (fileStatus != null) {
      hql += " AND front.fileStatus = :fileStatus ";
      countSql += " AND front.fileStatus = :fileStatus ";
    }

    hql += " order by front.createTime desc ";

    // 构造HQL查询 和 数量查询
    Query query = this.entityManager.createQuery(hql);
    Query countQuery = this.entityManager.createQuery(countSql);

    // 解译查询条件
    query.setParameter("projectName", platformContext.getAppName());
    countQuery.setParameter("projectName", platformContext.getAppName());
    if (name != null) {
      query.setParameter("name", name);
      countQuery.setParameter("name", name);
    }
    if (fileClassify != null) {
      query.setParameter(FILE_CLASSIFY, fileClassify);
      countQuery.setParameter(FILE_CLASSIFY, fileClassify);
    }
    // 模板名称fileStatus
    if (fileStatus != null) {
      query.setParameter(FILE_STATUS, fileStatus);
      countQuery.setParameter(FILE_STATUS, fileStatus);
    }

    // 构造返回信息和最新的分页结果
    query.setFirstResult(pageable.getPageNumber() * pageable.getPageSize());
    query.setMaxResults(pageable.getPageSize());
    List<FrontFileEntity> resutls = query.getResultList();

    // 查询总数量信息
    Long count = (Long) countQuery.getResultList().get(0);
    return new PageImpl<>(resutls, pageable, count.longValue());
  }

  /**
   * 不分页查询
   * @param conditions
   * @return
   */
  @SuppressWarnings("unchecked")
  @Override
  public List<FrontFileEntity> findAllByConditions(Map<String, Object> conditions) {
    // 目前支持前端文件名称，分类，文件状态进行查询
    StringBuilder hql = new StringBuilder("from FrontFileEntity front where 1=1 ");
    Map<String, Object> parameters = new HashMap<>();
    // name
    String name = (String) conditions.get("name");
    if (StringUtils.isNotBlank(name)) {
      hql.append(" AND front.name = :name");
      parameters.put("name", name);
    }
    // fileStatus
    String fileClassify = (String) conditions.get(FILE_CLASSIFY);
    if (StringUtils.isNotBlank(fileClassify)) {
      hql.append(" AND front.fileClassify = :fileClassify ");
      parameters.put(FILE_CLASSIFY, fileClassify);
    }
    // 文件状态
    Object fileStatus = conditions.get(FILE_STATUS);
    if (fileStatus != null) {
      hql.append(" AND front.fileStatus = :fileStatus ");
      parameters.put(FILE_STATUS, fileStatus);
    }
    hql.append(" order by front.createTime desc ");
    Query query = entityManager.createQuery(hql.toString());
    parameters.forEach((k, v) -> query.setParameter(k, v));
    return query.getResultList();
  }
}
