package com.bizunited.platform.kuiper.starter.repository.internal;

import com.bizunited.platform.common.constant.PlatformContext;
import com.bizunited.platform.common.repository.PageRepositoryImpl;
import com.bizunited.platform.kuiper.entity.PageFlowEntity;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

/**
 * 页面流持久化定制方法
 * @Author: TanBoQiuYun
 * @Date: 2019/12/31 15:48
 */
@Repository("PageFlowRepositoryImpl")
public class PageFlowRepositoryImpl implements PageFlowRepositoryCustom, PageRepositoryImpl {

  private static final String PAGE_FLOW_NAME = "name";
  private static final String PAGE_FLOW_CODE = "code";

  @Autowired
  @PersistenceContext
  private EntityManager entityManager;
  @Autowired
  private PlatformContext platformContext;

  @Override
  public Page<PageFlowEntity> findByConditions(PageFlowEntity pageFlow, Pageable pageable) {
    StringBuilder hql = new StringBuilder("from PageFlowEntity pf left join fetch pf.pages where 1=1 ");
    StringBuilder countHql = new StringBuilder("select count(*) from PageFlowEntity pf where 1=1 ");
    StringBuilder condition = new StringBuilder();
    condition.append(" and pf.projectName=:projectName ");
    Map<String, Object> parameter = new HashMap<>(9);
    parameter.put("projectName", platformContext.getAppName());
    if (pageFlow != null){
      if (StringUtils.isNotBlank(pageFlow.getName())){
        condition.append(" AND pf.name like CONCAT(CONCAT('%', :name), '%') ");
        parameter.put(PAGE_FLOW_NAME, pageFlow.getName());
      }
      if (StringUtils.isNotBlank(pageFlow.getCode())){
        condition.append(" AND pf.code like CONCAT(CONCAT('%', :code), '%') ");
        parameter.put(PAGE_FLOW_CODE, pageFlow.getCode());
      }
    }
    hql.append(condition).append(" order by pf.createTime desc ");
    countHql.append(condition);
    return queryByConditions(entityManager, hql.toString(), countHql.toString(), parameter, pageable, false, null);
  }
}
