package com.bizunited.platform.kuiper.starter.repository.internal;

import java.util.List;
import java.util.Map;

import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Repository;

import com.bizunited.platform.kuiper.entity.TemplateEntity;

/**
 * 自定义的比较复杂的表单模板信息的数据层操作定义
 * @author yinwenjie
 */
@Repository("TemplateRepositoryCustom")
public interface TemplateRepositoryCustom {
  Page<TemplateEntity> findByConditions(Pageable pageable , Map<String, Object> conditions);

  /**
   * 根据条件查询所有模版数据
   * @param condition
   * @return
   */
  List<TemplateEntity> findAllByConditions(TemplateEntity condition);
}