package com.bizunited.platform.kuiper.starter.service;

import com.bizunited.platform.common.model.MigrateImportModel;
import com.bizunited.platform.kuiper.entity.FrontFileEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Set;

/**
 * 前端文件存储服务
 */
public interface FrontFileSevice {
  /**
   * 新建脚本
   * @param frontFileEntityStr
   * @param fileContent
   * @return
   */
  FrontFileEntity create(String frontFileEntityStr, String fileContent);
  /**
   * 更新脚本
   * @param frontFileEntityStr
   * @param fileContent
   * @return
   */
  FrontFileEntity update(String frontFileEntityStr, String fileContent);

  /**
   * 创建实体
   * @param frontFileEntity
   * @return
   */
  FrontFileEntity saveEntity(FrontFileEntity frontFileEntity);

  /**
   * 更新实体
   * @param frontFileEntity
   * @return
   */
  FrontFileEntity updateEntity(FrontFileEntity frontFileEntity);

  /**
   * 禁用脚本
   * @param frontFileId
   * @return
   */
  FrontFileEntity disable(String frontFileId);
  /**
   * 启用脚本
   * @param frontFileId
   * @return
   */
  FrontFileEntity enable(String frontFileId);
  /**
   * 根据名称删除数据库记录，并删除文件
   * @param frontFileName
   */
  void deleteByName(String frontFileName);
  /**
   * 根据ID查询脚本内容
   * @param frontFileId
   * @return
   */
  String findContentById(String frontFileId);


  /**
   * 根据名称查询文件内容
   * @param frontFileName
   * @return
   */
  String findContentByName(String frontFileName);
  /**
   * 根据名称查询实体
   * @param name
   * @return
   */
  FrontFileEntity findByName(String name);
  /**
   * 按照前端头函数信息的id进行查询，查询基本信息
   * @param id
   * @return
   */
  FrontFileEntity findById(String id);
  /**
   * 分页查询脚本
   * @param pageable
   * @param name
   * @param classify
   * @param status
   * @return
   */
  Page<FrontFileEntity> queryPage(Pageable pageable, String name, String classify, Integer status);
  /**
   * 查询一批指定的id编号的前端头函数信息在系统中真实存在的数量
   * @param ids
   * @return
   */
  public int countByIds(String[] ids);

  /**
   * 根据指定的id数组查询
   * @param frontFileIds
   * @return
   */
  Set<FrontFileEntity> findByIds(String[] frontFileIds);

  /**
   * 查询所有页面函数
   * @return
   */
  List<FrontFileEntity> findAll();

  /**
   * 导入页面函数
   * @param importModel
   */
  void importData(MigrateImportModel importModel);

  /**
   * 不分页查询
   * @param name
   * @param classify
   * @param status
   * @return
   */
  List<FrontFileEntity> findAllByConditions(String name, String classify, Integer status);

  /**
   * 根据文件路径和文件名查询实体
   * @param filePath
   * @param fileName
   * @return
   */
  FrontFileEntity findByFilePathAndFileName(String filePath, String fileName);
}