package com.bizunited.platform.kuiper.starter.service;

import com.bizunited.platform.kuiper.entity.TemplateVisibilityAttributesEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityEntity;

import java.util.Set;

/**
 * 表单模版可见性属性服务接口定义
 * @Author: Paul Chan
 * @Date: 2019-07-22 14:51
 */
public interface TemplateVisibilityAttributeService {

  /**
   * 保存可见性的属性
   * @param visibility
   * @param attributes
   * @return
   */
  Set<TemplateVisibilityAttributesEntity> save(TemplateVisibilityEntity visibility, Set<TemplateVisibilityAttributesEntity> attributes);

  /**
   * 根据可见性ID删除
   * @param visibilityId
   */
  void deleteByVisibilityId(String visibilityId);

  /**
   * 根据可见性ID和布局查询属性
   * @param id
   * @param layoutType
   * @return
   */
  Set<TemplateVisibilityAttributesEntity> findByVisibilityIdAndLayoutType(String visibilityId, Integer layoutType);
}
