package com.bizunited.platform.kuiper.starter.service;


import com.bizunited.platform.kuiper.entity.TemplateVisibilityButtonsEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityEntity;

import java.util.Set;

/**
 * 表单模版可见性按钮服务接口定义
 * @Author: Paul Chan
 * @Date: 2019-07-22 14:54
 */
public interface TemplateVisibilityButtonService {

  /**
   * 保存可见性按钮
   * @param visibility
   * @param buttons
   */
  Set<TemplateVisibilityButtonsEntity> save(TemplateVisibilityEntity visibility, Set<TemplateVisibilityButtonsEntity> buttons);

  /**
   * 根据可见性ID删除
   * @param visibilityId
   */
  void deleteByVisibilityId(String visibilityId);

  /**
   * 根据可见性ID和布局查询按钮
   * @param id
   * @param layoutType
   */
  Set<TemplateVisibilityButtonsEntity> findByVisibilityIdAndLayoutType(String visibilityId, Integer layoutType);
}
