package com.bizunited.platform.kuiper.starter.service;

import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.entity.TemplateVisibilityEntity;
import com.bizunited.platform.saturn.model.PersistentClass;

import java.util.Set;

public interface TemplateVisibilityService {

  /**
   * 根据接收的表单信息(模板编号、表单可见性、表单属性、表单按钮)保存到数据库
   * @param template 表单模板
   * @param visibilities 可见性
   * @return
   */
  Set<TemplateVisibilityEntity> save(TemplateEntity template, Set<TemplateVisibilityEntity> visibilities);
  
  /**
   * 根据静态模型的基本信息，关联的基本属性、关联属性、分组属性初始化一个名叫create的可见性信息，
   * 这个可见性信息目前不能被删除的（可以被修改）
   * 会初始化静态模型明细下的基本属性和关联属性
   * 会初始化静态模型分组下的基本属性、关联属性、明细
   * 会初始化静态模型分组下的明细的基本属性和关联属性
   * @param templateId 
   * @param persistentClass
   * @return
   */
  public Set<TemplateVisibilityEntity> initStaticTemplateVisibilities(String templateId , PersistentClass persistentClass);
  
  /**
   * 根据动态模型的基本信息，关联的基本属性、关联属性、分组属性初始化一个名叫create的可见性信息，
   * 这个可见性信息目前不能被删除的（可以被修改）
   * 会初始化静态模型明细下的基本属性和关联属性
   * 会初始化静态模型分组下的基本属性、关联属性、明细
   * 会初始化静态模型分组下的明细的基本属性和关联属性
   * @param template 动态模板对象
   * @return
   */
  public Set<TemplateVisibilityEntity> initDynamicTemplateVisibilities(TemplateEntity template);
  
  /**
   * 该服务不需要公布到controller层，只限于在进行表单模板升级时，负责可见性信息的升级操作
   * @param templateId
   * @param templateVisibilities 参照的一个或者多个可见性信息
   * @return 
   */
  public Set<TemplateVisibilityEntity> upgrade(String templateId , Set<TemplateVisibilityEntity> templateVisibilities);
  
  /**
   * 按照模板信息，删除指定模板下的可见性信息
   * @param templateId
   */
  public void deleteByTemplateId(String templateId);
  
  /**
   * 按照指定的模板数据编号和指定的可见性名称，查询指定的可见性信息
   * @param templateId 指定的模板编号信息
   * @param visibilityName 指定的可见性名称
   * @return
   */
  public TemplateVisibilityEntity findByTemplateIdAndVisibilityName(String templateId , String visibilityName);
  
  /**
   * 根据模板id查询可见性信息，包括表单可见性以及关联信息(表单属性信息、表单按钮信息)
   * ，并按照创建顺序进行返回
   * @param templateId：指定数据层模板编号
   * @return 表单可见性、表单属性、表单按钮信息
   */
  public Set<TemplateVisibilityEntity> findDetailsByTemplateId(String templateId);

  /**
   * 根据模板id和布局类型查询可见性信息，包括表单可见性以及关联信息(表单属性信息、表单按钮信息)
   * @param templateId
   * @param layoutType
   * @return
   */
  Set<TemplateVisibilityEntity> findDetailsByTemplateIdAndLayoutType(String templateId, Integer layoutType);

  /**
   * 根据指定模板、可见性名称和布局查询可见性
   * @param templateId
   * @param visibilityName
   * @param layoutType
   * @return
   */
  TemplateVisibilityEntity findDetailsByTemplateIdAndVisibilityNameAndLayoutType(String templateId, String visibilityName, Integer layoutType);

  /**
   * 根据模版code和版本号查询可见性,如果不传版本号，则使用默认的版本号
   * @param templateCode
   * @param version
   * @return
   */
  Set<TemplateVisibilityEntity> findByTemplateCodeAndVersion(String templateCode, String version);
}
