package com.bizunited.platform.kuiper.starter.service.instances.handle;

import com.bizunited.platform.kuiper.entity.InstanceActivityEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONObject;
import com.bizunited.platform.core.service.invoke.HandleChain;
import com.bizunited.platform.core.service.invoke.InvokeParams;
import com.bizunited.platform.core.service.invoke.InvokeProxyContext;
import com.bizunited.platform.core.service.invoke.InvokeProxyException;
import com.bizunited.platform.core.service.invoke.InvokeRequestHandle;
import com.bizunited.platform.kuiper.service.DynamicInstanceService;
import com.bizunited.platform.kuiper.starter.service.InstanceActivityService;

/**
 * 该处理器在动态表单实例发生“写”性质的操作前，进行指定表单实例详细情况的查询和记录。
 * @author yinwenjie
 */
@Component("DynamicFormDetailsRequestHandle")
public class DynamicFormDetailsRequestHandle extends AbstractDynamicFormDetailsHandle implements InvokeRequestHandle {
  private static final Logger LOGGER = LoggerFactory.getLogger(DynamicFormDetailsRequestHandle.class);
  /**
   * 用于存储前置处理得到的查询结果值的key
   */
  private static final String BEFORE_DETAILS = "_beforeDetails";
  /**
   * 动态实例服务
   */
  @Autowired
  private DynamicInstanceService dynamicInstanceService;
  @Autowired
  private InstanceActivityService instanceActivityService;

  
  @Override
  public void doHandle(InvokeProxyContext context, HandleChain chain) throws InvokeProxyException {
    if(context.isException()) {
      return;
    }
    InvokeParams invokeParams = context.getParams();
    JSONObject formDateJson = null;
    
    
    /*
     * -处理过程为：
     * 1、专门用于动态表单在进行添加数据、修改数据前的原始数据详情读取工作
     * 这个工作用于DynamicInstanceServiceImpl.create(JSONObject)方法的request handle中
     * 所以instanceId来源于动态表单的json结构中
     * 
     * 2、调用dynamicInstanceService服务中的调用查询方法，并得到json信息
     * 3、将json信息记录到调用上下文中，以便后续使用
     * */

    
    // 1、=========
    // 确认查询数据详情的依据，如果没有任何依据，也不会执行数据记录
    Object[] variables = invokeParams.getVariables();
    JSONObject formData = (JSONObject)variables[0];
    Validate.notNull(formData , "错误的动态数据入参信息!!");
    String instanceId = null;
    String instanceActivityId = formData.getString("instanceActivityId");
    if(StringUtils.isBlank(instanceActivityId)){
      instanceId = formData.getString("formInstanceId");
      instanceActivityId = this.instanceActivityService.findIdByMaxCreateTime(instanceId);
    }else {
      InstanceActivityEntity instanceActivity = this.instanceActivityService.findDetailsById(instanceActivityId);
      instanceId = instanceActivity.getInstance().getId();
    }
    Validate.notBlank(instanceActivityId , "根据指定的实例活动[%s]，未找到对应的信息，请检查!!" , instanceId);
    invokeParams.putInvokeParam("instanceId", instanceId);
    invokeParams.putInvokeParam("instanceActivityId", instanceActivityId);
    
    // 2、=========
    formDateJson = dynamicInstanceService.findDetailsByFormInstanceId(instanceId);
    if(formDateJson == null) {
      formDateJson = new JSONObject();
    }
    
    // 3、=========
    //前置存储json
    LOGGER.debug("前置数据：{}", formDateJson);
    invokeParams.putInvokeParam(BEFORE_DETAILS, formDateJson);
    chain.doHandle(context, HandleChain.ChainLogic.CONTINUE);
  }
}
