package com.bizunited.platform.kuiper.starter.service.instances.imports;

import java.util.Map;
import java.util.Set;

import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import com.bizunited.platform.kuiper.entity.FormInstanceUuidEntity;

/**
 * 该接口有V2.0.2.43版本开始提供个，用于帮助业务开发人员完成基于一个Entity模型的数据批量导出工作</br>
 * 这个导入过程将基于xlsx文件，整个导入过程分为validate过程和execute过程。</p>
 * 
 * 注意这个接口所对应的业务数据:</br>
 * 1、xls分析后的entity模型，必须是业务构建平台中定义的主模型</br>
 * 2、该业务数据导入功能涉及到的业务，必须是nebula业务构建平台中已经存在表单模板的业务
 * 
 * @author yinwenjie
 */
public interface FromDetailsImportProcess<T extends FormInstanceUuidEntity> {
  /**
   * 该步骤在正式依据导入的xls数据创建业务数据前，检查导入数据的正确性，并将xls信息正确组装成nebula业务构建平台能够识别的表单数据信息。
   * 如果检查过程中出现问题，则直接抛出异常即可终止整个业务数据导入过程。
   * @param wk 由前端调用者传来的xls信息，目前只能是xls后者xlsx文件，否则将在进入方法前就抛出异常
   * @param params 在进行xls信息导入时，可以由调用者根据实际的业务处理场景，传入自定义的K-V结构的外部参数，这些K-V结构的参数都记录在这里
   * @param templateCode 导入业务数据后，将为业务数据创建表单实例，该templateCode指向将要创建表单实例时所参照的模板
   * @param templateVersion 导入业务数据后，将为业务数据创建表单实例，该templateVersion指向将要创建表单实例时所参照的模板版本
   * @return 
   */
  public Set<T> validate(XSSFWorkbook wk , Map<String, Object> params , String templateCode , String templateVersion);
  
  /**
   * 该步骤是正式的业务数据导入处理过程，在该步骤，业务开发人员可专注与业务数据的处理，不必担心表单实例的创建过程。</br>
   * 因为在该方法正式开始前，该业务数据所需要的表单实例信息已经绑定到相关业务对象中。
   * @param contents 相关设置信息
   * @param params
   */
  public void execute(Set<T> contents , Map<String, Object> params);
}