package com.bizunited.platform.kuiper.starter.service.internal;

import com.bizunited.platform.kuiper.entity.FormDetailsImportBoxEntity;
import com.bizunited.platform.kuiper.entity.InstanceEntity;
import com.bizunited.platform.kuiper.entity.TemplateEntity;
import com.bizunited.platform.kuiper.service.InstanceService;
import com.bizunited.platform.kuiper.service.TemplateService;
import com.bizunited.platform.kuiper.starter.service.FormDetailesImportBoxExtService;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ReflectionUtils;

import java.lang.reflect.Field;
import java.util.List;
import java.util.Optional;

/**
 * @author Keller
 */
@Service
public class FormDetailesImportBoxExtServiceImpl implements FormDetailesImportBoxExtService {

  @Autowired
  private TemplateService templateService;
  @Autowired
  private InstanceService instanceService;

  @Override
  public void fillFormInstanceId(FormDetailsImportBoxEntity entity, Object bean, String account) {
    //检查bean中是否有formInstanceId 字段
    Field field = FieldUtils.getField(bean.getClass(), "formInstanceId", true);
    if (StringUtils.isNoneBlank(entity.getTemplateCode()) && field != null) {
      // 检验模板信息
      TemplateEntity currentTemplate = null;
      // 如果条件成立，则使用默认版本
      if (StringUtils.isBlank(entity.getTemplateVersion())) {
        List<TemplateEntity> templetes = this.templateService.findByCode(entity.getTemplateCode());
        Validate.notNull(templetes, "未找到指定的表单模板信息[%s]，请检查!!", entity.getTemplateCode());
        Optional<TemplateEntity> templateOp = templetes.stream().filter(item -> item.getDefaultVersion()).findFirst();
        currentTemplate = templateOp.orElse(null);
        Validate.notNull(currentTemplate, "未找到指定的表单模板的默认版本信息[%s]，请检查!!", entity.getTemplateCode());
      } else {
        currentTemplate = this.templateService.findByCodeAndCversion(entity.getTemplateCode(), entity.getTemplateVersion());
        Validate.notNull(currentTemplate, "未找到指定的表单模板信息[%s : %s]，请检查!!", entity.getTemplateCode(), entity.getTemplateVersion());
      }
      InstanceEntity instance = this.instanceService.createByTemplateCode(currentTemplate.getCode(), currentTemplate.getCversion(), null, account);
      //反射对象在写入值
      ReflectionUtils.setField(field, bean, instance.getId());
    }
  }
}
