package com.bizunited.platform.kuiper.starter.configuration;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

/**
 * 允许跨域的配置信息在这里
 * 
 * @author yinwenjie
 */
@Configuration
public class CrossDomainConfig {
  /**
   * attention:简单跨域就是GET，HEAD和POST请求， 
   * 但是POST请求的"Content-Type"只能是application/x-www-form-urlencoded，multipart/form-data 或 text/plain<br>
   * 反之，就是非简单跨域，此跨域有一个预检机制。说直白点，就是会发两次请求，一次OPTIONS请求，一次真正的请求
   */
  @Bean
  public WebMvcConfigurer corsConfigurer() {
    return new WebMvcConfigurer() {
      @Override
      public void addCorsMappings(CorsRegistry registry) {
        registry.addMapping("/**")
        // #允许向该服务器提交请求的URI，*表示全部允许，在SpringMVC中，如果设成*，会自动转成当前请求头中的Origin
        .allowedOrigins("*")
        // #允许访问的头信息,*表示全部
        .allowedHeaders("*")
        // 允许cookies跨域
        .allowCredentials(true)
        // 允许提交请求的方法，*表示全部允许
        .allowedMethods("*")
        .exposedHeaders("JSESSIONID,persistence,Cookie")
        // 预检请求的缓存时间（秒），即在这个时间段里，对于相同的跨域请求不会再预检了
        .maxAge(18000L);
      }
    };
  }
}