package com.bizunited.platform.kuiper.starter.configuration;

import com.bizunited.platform.kuiper.starter.service.KuiperToolkitService;
import com.github.xiaoymin.swaggerbootstrapui.annotations.EnableSwaggerBootstrapUI;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import springfox.documentation.swagger2.annotations.EnableSwagger2;

/**
 * 使用该标识性质的注解，标记在业务工程的Service层，
 * 表示这个service可以通过表单引擎直接向表单模板开放
 *
 * @author yinwenjie
 */
@Configuration
@EnableAutoConfiguration
//启动swagger配置
@EnableSwagger2
@EnableSwaggerBootstrapUI
@EntityScan(basePackages = "com.bizunited.platform.kuiper.entity")
@EnableJpaRepositories(basePackages = "com.bizunited.platform.kuiper.starter.repository")
@ComponentScan(basePackages = {"com.bizunited.platform.kuiper", "com.bizunited.platform.core", "com.bizunited.platform.common"})
public class KuiperServiceConfig {

  @Bean("KuiperToolkitService")
  public KuiperToolkitService getKuiperToolkitService() {
    return new KuiperToolkitService();
  }
}
