package com.bizunited.platform.kuiper.starter.controller;

import com.bizunited.platform.common.controller.BaseController;
import com.bizunited.platform.common.controller.model.ResponseModel;
import com.bizunited.platform.kuiper.entity.DynamicTemplateDraftEntity;
import com.bizunited.platform.kuiper.starter.service.DynamicTemplateDraftService;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 动态模板草稿功能业务模型的MVC Controller层实现，基于HTTP Restful风格
 * @author saturn
 */
@RestController
@RequestMapping("/v1/kuiper/dynamicTemplateDrafts")
public class DynamicTemplateDraftController extends BaseController {
  /**
   * 日志
   */
  private static final Logger LOGGER = LoggerFactory.getLogger(DynamicTemplateDraftController.class);

  @Autowired
  private DynamicTemplateDraftService dynamicTemplateDraftService;

  /**
   * 创建一条动态模板的草稿
   *
   * @param dynamicTemplateDraftEntity 接收表单参数的实体
   * @param json 动态模板的草稿json数据
   * @return
   */
  @ApiOperation(value = "创建一条动态模板的草稿")
  @PostMapping(value="")
  public ResponseModel create(DynamicTemplateDraftEntity dynamicTemplateDraftEntity, @RequestBody @ApiParam(name="json" , value="动态模板的草稿json数据", required = true) String json) {
    try {
      DynamicTemplateDraftEntity current = this.dynamicTemplateDraftService.create(dynamicTemplateDraftEntity , json);
      return this.buildHttpResultW(current);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 更新一条动态模板的草稿
   * */
  @ApiOperation(value = "更新一条动态模板的草稿")
  @PatchMapping("")
  public ResponseModel update(@RequestBody @ApiParam(name="json" , value="动态模板的草稿json数据", required = true) String json,DynamicTemplateDraftEntity dynamicTemplateDraft) {
    try {
      DynamicTemplateDraftEntity current = this.dynamicTemplateDraftService.update(dynamicTemplateDraft, json);
      return this.buildHttpResultW(current);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }


  /**
   * 分页查询动态模板的草稿
   * @param tableName 动态模板设定的数据表名
   * @param pageable
   * @return
   */
  @GetMapping(value="/findByConditions")
  @ApiOperation(value = "分页查询动态模板的草稿", notes = "页数参数为page，第一页从0开始，分页大小参数为size（默认size为50）")
  public ResponseModel findByConditions(@ApiParam(name = "tableName", value = "动态模板设定的数据表名") @RequestParam(value = "tableName", required = false) String tableName,
                                        @PageableDefault(value = 50) Pageable pageable){
    try {
      Page<DynamicTemplateDraftEntity> page = this.dynamicTemplateDraftService.findByConditions(pageable, tableName);
      return this.buildHttpResultW(page);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 按照主键进行查询明细查询，查询的明细包括当前业务表单所有的关联属性。
   * 请注意，该方法查询的内容不包括任务草稿json内容的组织形式
   * @param id 主键
   */
  @ApiOperation(value = "按照主键进行查询明细查询", notes = "查询的明细包括当前业务表单所有的关联属性。")
  @GetMapping("/findDetailsById")
  public ResponseModel findDetailsById(@RequestParam("id") @ApiParam("主键") String id) {
    try {
      DynamicTemplateDraftEntity result = this.dynamicTemplateDraftService.findDetailsById(id);
      return this.buildHttpResultW(result);
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 根据主键ID查询草稿JSON数据
   * @param id 主键ID
   * @return
   */
  @ApiOperation(value = "根据主键ID查询草稿JSON数据")
  @GetMapping("/findJsonById")
  public ResponseModel findJsonById(@RequestParam("id") @ApiParam(value = "主键", required = true) String id) {
    try {
      String json = this.dynamicTemplateDraftService.findJsonById(id);
      return this.buildHttpResultW(json);
    } catch (RuntimeException e) {
      LOGGER.error(e.getMessage(), e);
      return this.buildHttpResultForException(e);
    }
  }

  /**
   * 根据主键删除模版草稿
   * 此方法为真删除
   * @param id
   * @return
   */
  @DeleteMapping("/{id}")
  @ApiOperation(value = "根据主键删除模版草稿")
  public ResponseModel deleteById(@PathVariable("id") @ApiParam(value = "主键", required = true) String id){
    try {
      dynamicTemplateDraftService.deleteById(id);
      return this.buildHttpResult();
    } catch(RuntimeException e) {
      LOGGER.error(e.getMessage() , e);
      return this.buildHttpResultForException(e);
    }
  }


}
