package com.bizunited.platform.kuiper.starter.repository;

import com.bizunited.platform.kuiper.entity.FrontFileEntity;
import com.bizunited.platform.kuiper.starter.repository.internal.FrontFileRepositoryCustom;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.Set;

@Repository("FrontFileRepository")
public interface FrontFileRepository
    extends JpaRepository<FrontFileEntity, String>,
        JpaSpecificationExecutor<FrontFileEntity>,
        FrontFileRepositoryCustom {

  /**
   * 根据名称查询实体
   * @param name
   * @return
   */
  FrontFileEntity findByNameAndProjectName(String name, String projectName);
  /**
   * 查询一批指定的id编号的前端头函数信息在系统中真实存在的数量
   * @param ids
   * @return
   */
  @Query(value="select count(*) from engine_form_front_file where id in (:ids)" , nativeQuery = true)
  public int countByIds(@Param("ids") String[] ids);

  /**
   * 根据指定的id数组查询
   * @param frontFileIds
   * @return
   */
  @Query(value="select ff from FrontFileEntity ff "
          + " where ff.id in (:frontFileIds) ")
  Set<FrontFileEntity> findByIds(@Param("frontFileIds") String[] frontFileIds);

  /**
   * 根据文件路径和文件名查询实体
   * @param filePath
   * @param fileName
   * @return
   */
  FrontFileEntity findByFilePathAndFileName(String filePath, String fileName);
}
