package com.bizunited.platform.kuiper.starter.repository;

import com.bizunited.platform.kuiper.entity.InstanceContextEntity;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

import java.util.List;

/**
 * @Author: Paul Chan
 * @Date: 2019-04-19 11:32
 * @Description: 表单实上下文例库
 */
@Repository("InstanceContextRepository")
public interface InstanceContextRepository extends
    JpaRepository<InstanceContextEntity, String>
    , JpaSpecificationExecutor<InstanceContextEntity> {


  /**
   * 根据表单实例ID查询上下文
   * @param instanceId
   * @return
   */
  @Query("select ic from InstanceContextEntity ic join ic.instance i where i.id = :instanceId ")
  List<InstanceContextEntity> findByInstanceId(@Param("instanceId") String instanceId);

  /**
   * 根据表单实例ID和name查询上下文
   * @param instanceId
   * @param name
   * @return
   */
  @Query("select ic from InstanceContextEntity ic join ic.instance i where i.id = :instanceId and ic.name = :name ")
  InstanceContextEntity findByInstanceContextIdAndName(@Param("instanceId") String instanceId, @Param("name") String name);
}
